/*
 * Decompiled with CFR 0.152.
 */
package gabien.atlas;

import gabien.GaBIEn;
import gabien.atlas.AtlasDrawable;
import gabien.atlas.AtlasSet;
import gabien.atlas.IAtlasStrategy;
import gabien.render.IGrDriver;
import gabien.render.ITexRegion;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.function.Consumer;

public final class SimpleAtlasBuilder {
    private LinkedList<Entry> entries = new LinkedList();
    private final Size pageSize;
    private final IAtlasStrategy pageStrategy;

    public SimpleAtlasBuilder(int atlasW, int atlasH, IAtlasStrategy pageStrategy) {
        this.pageSize = new Size(atlasW, atlasH);
        this.pageStrategy = pageStrategy;
    }

    public void add(Consumer<ITexRegion> result, AtlasDrawable src) {
        this.entries.add(new Entry(result, src));
    }

    public AtlasSet compile() {
        Entry[] entriesArray = this.entries.toArray(new Entry[0]);
        Comparator<Size> sizeSorter = this.pageStrategy.getSortingAlgorithm();
        Arrays.sort(entriesArray, (a, b) -> sizeSorter.compare(a.sz, b.sz));
        int amountInArray = entriesArray.length;
        AtlasSet res = new AtlasSet();
        while (amountInArray > 0) {
            int change = this.compilePage(res, entriesArray);
            if (change == 0) {
                for (int i = 0; i < entriesArray.length; ++i) {
                    Entry e = entriesArray[i];
                    if (e == null) continue;
                    IGrDriver ap = GaBIEn.makeAtlasPage(e.sz.width, e.sz.height);
                    e.tex.drawTo(ap, 0, 0);
                    e.key.accept(ap);
                    res.pages.add(ap);
                    entriesArray[i] = null;
                    --amountInArray;
                }
                continue;
            }
            amountInArray -= change;
        }
        return res;
    }

    private int compilePage(AtlasSet res, Entry[] entriesArray) {
        for (int i = 0; i < entriesArray.length; ++i) {
            Entry eI = entriesArray[i];
            if (eI == null) continue;
            for (int j = i + 1; j < entriesArray.length; ++j) {
                Rect rcJ;
                IAtlasStrategy.Instance instance;
                Rect rcI;
                Entry eJ = entriesArray[j];
                if (eJ == null || (rcI = (instance = this.pageStrategy.instance(this.pageSize)).add(eI.sz)) == null || (rcJ = instance.add(eJ.sz)) == null) continue;
                entriesArray[i] = null;
                entriesArray[j] = null;
                Rect[] seedTest = new Rect[]{rcI, rcJ};
                return this.compilePageWithSeed(res, entriesArray, seedTest, eI, eJ, instance);
            }
        }
        return 0;
    }

    private int compilePageWithSeed(AtlasSet res, Entry[] entriesArray, Rect[] currentBest, Entry eI, Entry eJ, IAtlasStrategy.Instance instance) {
        Entry[] currentBestContents = new Entry[]{eI, eJ};
        while (true) {
            Entry[] nextContents = new Entry[currentBest.length + 1];
            Rect[] nextRects = new Rect[currentBest.length + 1];
            System.arraycopy(currentBestContents, 0, nextContents, 0, currentBest.length);
            System.arraycopy(currentBest, 0, nextRects, 0, currentBest.length);
            int foundSomething = -1;
            for (int i = 0; i < entriesArray.length; ++i) {
                Entry e = entriesArray[i];
                if (e == null) continue;
                nextContents[nextContents.length - 1] = e;
                Rect rct = instance.add(e.sz);
                if (rct == null) continue;
                foundSomething = i;
                nextRects[nextRects.length - 1] = rct;
                break;
            }
            if (foundSomething == -1) break;
            entriesArray[foundSomething] = null;
            currentBestContents = nextContents;
            currentBest = nextRects;
        }
        return this.finishCompilePage(res, currentBest, currentBestContents);
    }

    private int finishCompilePage(AtlasSet res, Rect[] currentBest, Entry[] currentBestContents) {
        IGrDriver ap = GaBIEn.makeAtlasPage(this.pageSize.width, this.pageSize.height);
        for (int i = 0; i < currentBest.length; ++i) {
            Rect r = currentBest[i];
            Entry e = currentBestContents[i];
            e.tex.drawTo(ap, r.x, r.y);
            e.key.accept(ap.subRegion(r.x, r.y, e.sz.width, e.sz.height));
        }
        res.pages.add(ap);
        return currentBest.length;
    }

    private static class Entry {
        final Consumer<ITexRegion> key;
        final Size sz;
        final AtlasDrawable tex;

        Entry(Consumer<ITexRegion> key, AtlasDrawable tex) {
            this.key = key;
            this.tex = tex;
            this.sz = new Size(tex.width, tex.height);
        }
    }
}

