/*
 * Decompiled with CFR 0.152.
 */
package gabien.atlas;

import gabien.atlas.IAtlasStrategy;
import gabien.uslx.append.Rect;
import gabien.uslx.append.Size;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class BinaryTreeAtlasStrategy
implements IAtlasStrategy {
    public static final BinaryTreeAtlasStrategy INSTANCE = new BinaryTreeAtlasStrategy();

    @Override
    @NonNull
    public IAtlasStrategy.Instance instance(@NonNull Size atlasSize) {
        final TreeNode root = new TreeNode(new Rect(atlasSize), null);
        return new IAtlasStrategy.Instance(){

            @Override
            @Nullable
            public Rect add(@NonNull Size size) {
                return root.place(size);
            }
        };
    }

    @Override
    @Nullable
    public Comparator<Size> getSortingAlgorithm() {
        return SORT_HEIGHT_THEN_WIDTH;
    }

    private static enum Occupancy {
        NONE,
        FULL,
        SPLIT;

    }

    private static class TreeNode {
        final Rect location;
        Occupancy mode = Occupancy.NONE;
        @Nullable
        TreeNode a;
        @Nullable
        TreeNode b;
        @Nullable
        TreeNode p;
        int weight;

        TreeNode(Rect l, TreeNode p) {
            this.p = p;
            this.location = l;
            this.modWeight(1);
        }

        void modWeight(int mod) {
            this.weight += mod;
            if (this.p != null) {
                this.p.modWeight(mod);
            }
        }

        @Nullable
        Rect place(Size size) {
            boolean justSplit = false;
            if (this.mode == Occupancy.NONE) {
                boolean canSplitH = this.location.width > 1 && size.width < this.location.width;
                boolean canSplitV = this.location.height > 1 && size.height < this.location.height;
                int splitChoice = 0;
                if (canSplitH && canSplitV) {
                    splitChoice = this.location.width < this.location.height ? 1 : 2;
                } else if (canSplitH) {
                    splitChoice = 2;
                } else if (canSplitV) {
                    splitChoice = 1;
                }
                if (splitChoice == 1) {
                    this.mode = Occupancy.SPLIT;
                    this.a = new TreeNode(new Rect(this.location.x, this.location.y, this.location.width, size.height), this);
                    this.b = new TreeNode(new Rect(this.location.x, this.location.y + size.height, this.location.width, this.location.height - size.height), this);
                    justSplit = true;
                } else if (splitChoice == 2) {
                    this.mode = Occupancy.SPLIT;
                    this.a = new TreeNode(new Rect(this.location.x, this.location.y, size.width, this.location.height), this);
                    this.b = new TreeNode(new Rect(this.location.x + size.width, this.location.y, this.location.width - size.width, this.location.height), this);
                    justSplit = true;
                } else if (size.width <= this.location.width && size.height <= this.location.height) {
                    this.mode = Occupancy.FULL;
                    return new Rect(this.location.x, this.location.y, size.width, size.height);
                }
            }
            if (this.mode == Occupancy.SPLIT) {
                Rect res = null;
                if (this.a.weight < this.b.weight) {
                    res = this.b.place(size);
                    if (res == null) {
                        res = this.a.place(size);
                    }
                } else {
                    res = this.a.place(size);
                    if (res == null) {
                        res = this.b.place(size);
                    }
                }
                if (justSplit && res == null && this.a.mode == Occupancy.NONE && this.b.mode == Occupancy.NONE) {
                    this.mode = Occupancy.NONE;
                    this.a.modWeight(-this.a.weight);
                    this.b.modWeight(-this.b.weight);
                    this.a = null;
                    this.b = null;
                }
                return res;
            }
            return null;
        }
    }
}

