/*
 * Decompiled with CFR 0.152.
 */
package gabien;

import gabien.GaBIEnImpl;
import gabien.IGJSEPeripheralsInternal;
import gabien.wsi.ITextEditingSession;
import java.awt.Font;
import java.awt.Panel;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.eclipse.jdt.annotation.NonNull;

public class TextboxMaintainer
implements ITextEditingSession {
    public final IGJSEPeripheralsInternal peripheralsInternal;
    public final Panel parent;
    public final boolean multiLine;
    public JTextComponent textComponent;
    public JComponent placeComponent;
    private KeyListener kl;
    @NonNull
    public String maintainedString;
    private boolean isFirstMaintain = true;
    public boolean sessionIsDead = false;
    public boolean enterFlag = false;

    public TextboxMaintainer(IGJSEPeripheralsInternal pi, Panel panel, KeyListener k, boolean ml, int textHeight, final Function<String, String> feedback, String initText) {
        this.peripheralsInternal = pi;
        if (textHeight < 16) {
            textHeight = 16;
        }
        this.parent = panel;
        this.kl = k;
        this.multiLine = ml;
        this.maintainedString = initText;
        this.textComponent = ml ? new JTextArea() : new JTextField();
        this.textComponent.setText(this.maintainedString);
        this.placeComponent = ml ? new JScrollPane(this.textComponent) : this.textComponent;
        this.parent.add(this.placeComponent);
        this.placeComponent.setBounds(0, 0, 32, textHeight + 1);
        this.textComponent.setFont(new Font("SansSerif", 0, textHeight));
        this.textComponent.addKeyListener(this.kl);
        this.textComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TextboxMaintainer.this.enterFlag = true;
                }
            }
        });
        if (GaBIEnImpl.mobileEmulation && feedback != null) {
            this.textComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    System.err.println("on mobile, feedback says:" + (String)feedback.apply(TextboxMaintainer.this.textComponent.getText()));
                }
            });
        }
    }

    @Override
    public String maintain(int x, int y, int width, int height) {
        return this.peripheralsInternal.aroundTheBorderworldMaintain(this, x, y, width, height);
    }

    public String maintainActual(int x, int y, int width, int height) {
        if (this.sessionIsDead) {
            return this.maintainedString;
        }
        if (!this.multiLine) {
            y += height / 2;
            y -= this.placeComponent.getHeight() / 2;
            height = this.placeComponent.getHeight();
        }
        boolean needToMove = false;
        if (this.placeComponent.getX() != x) {
            needToMove = true;
        }
        if (this.placeComponent.getY() != y) {
            needToMove = true;
        }
        if (this.placeComponent.getWidth() != width) {
            needToMove = true;
        }
        if (this.placeComponent.getHeight() != height) {
            needToMove = true;
        }
        if (needToMove) {
            this.placeComponent.setBounds(x, y, width, height);
        }
        if (this.isFirstMaintain) {
            this.textComponent.setVisible(true);
            this.textComponent.grabFocus();
            this.isFirstMaintain = false;
        }
        this.maintainedString = this.textComponent.getText();
        return this.maintainedString;
    }

    @Override
    public void setText(String text) {
        this.textComponent.setText(text);
        this.maintainedString = text;
    }

    @Override
    public boolean isEnterJustPressed() {
        return this.enterFlag;
    }

    @Override
    public void endSession() {
        if (this.sessionIsDead) {
            return;
        }
        this.parent.remove(this.placeComponent);
        this.parent.transferFocusUpCycle();
        this.sessionIsDead = true;
        this.peripheralsInternal.finishRemovingEditingSession();
    }

    @Override
    public boolean isSessionDead() {
        return this.sessionIsDead;
    }
}

