/*
 * Decompiled with CFR 0.152.
 */
package gabien;

import gabien.audio.IRawAudioDriver;
import gabien.backend.NullAudioSource;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.eclipse.jdt.annotation.NonNull;

final class RawSoundDriver
implements IRawAudioDriver,
Runnable {
    SourceDataLine sdl;
    private Thread soundThread = new Thread(this);
    private AtomicReference<IRawAudioDriver.IRawAudioSource> source = new AtomicReference<NullAudioSource>(new NullAudioSource());
    private boolean alive = true;

    public RawSoundDriver() throws LineUnavailableException {
        AudioFormat af = new AudioFormat(22050.0f, 16, 2, true, false);
        this.sdl = AudioSystem.getSourceDataLine(af);
        this.sdl.open(af);
        this.sdl.addLineListener(new LineListener(){

            @Override
            public void update(LineEvent event) {
                if (event.getType() == LineEvent.Type.STOP) {
                    try {
                        RawSoundDriver.this.sdl.start();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.sdl.start();
        this.soundThread.setName("Sound");
        this.soundThread.setPriority(10);
        this.soundThread.start();
    }

    public void createData(ShortBuffer dataB, short[] dataIL) {
        this.source.get().pullData(dataIL, 0, dataIL.length / 2);
        dataB.position(0);
        dataB.put(dataIL);
    }

    @Override
    public void run() {
        int frames = 2048;
        byte[] dataB = new byte[frames * 4];
        ByteBuffer bb = ByteBuffer.wrap(dataB);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer fb = bb.asShortBuffer();
        short[] dataIL = new short[frames * 2];
        while (this.alive) {
            this.createData(fb, dataIL);
            this.sdl.write(dataB, 0, dataB.length);
        }
    }

    @Override
    @NonNull
    public IRawAudioDriver.IRawAudioSource setRawAudioSource(@NonNull IRawAudioDriver.IRawAudioSource src) {
        return this.source.getAndSet(src);
    }

    public void shutdown() {
        this.alive = false;
    }
}

