/*
 * Decompiled with CFR 0.152.
 */
package gabien;

import gabien.GaBIEn;
import gabien.GrInDriver;
import gabien.IGJSEPeripheralsInternal;
import gabien.TextboxMaintainer;
import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.text.IFixedSizeFont;
import gabien.wsi.IPeripherals;
import gabien.wsi.IPointer;
import gabien.wsi.ITextEditingSession;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MobilePeripherals
implements IPeripherals,
IGJSEPeripheralsInternal {
    private final GrInDriver parent;
    private int offsetX;
    private int offsetY;
    private int activePointer;
    private LinkedList<DummyPointer> dummies = new LinkedList();
    private DummyPointer mousePointer;
    private IFixedSizeFont font;

    public MobilePeripherals(GrInDriver grInDriver) {
        this.parent = grInDriver;
        this.font = GaBIEn.getNativeFontFallback(16, null);
    }

    public void mobilePeripheralsFinishFrame(IImage backBuffer) {
        IGrDriver backBufferGr = null;
        if (backBuffer instanceof IGrDriver) {
            backBufferGr = (IGrDriver)backBuffer;
        }
        if (this.activePointer < 0) {
            this.activePointer = this.dummies.size() - 1;
        }
        if (this.activePointer >= this.dummies.size()) {
            this.activePointer = 0;
        }
        if (this.activePointer < 0) {
            this.activePointer = 0;
        }
        this.parent.mouseLock.lock();
        if (this.parent.mouseJustDown.contains(3)) {
            this.parent.mouseJustDown.remove(3);
            this.dummies.add(new DummyPointer(this.parent.mouseX, this.parent.mouseY));
        } else if (this.activePointer < this.dummies.size()) {
            if (this.parent.keysjd[13]) {
                this.dummies.remove(this.activePointer);
            } else if (this.parent.mousewheelMovements != 0) {
                ++this.activePointer;
                this.parent.mousewheelMovements = 0;
            } else if (this.parent.mouseDown.contains(2)) {
                DummyPointer dp = this.dummies.get(this.activePointer);
                dp.x = this.parent.mouseX;
                dp.y = this.parent.mouseY;
            }
        }
        this.parent.keysjd[13] = false;
        if (this.parent.mouseDown.contains(1)) {
            if (this.mousePointer == null) {
                this.mousePointer = new DummyPointer(0, 0);
                this.dummies.add(this.mousePointer);
            }
            this.mousePointer.x = this.parent.mouseX;
            this.mousePointer.y = this.parent.mouseY;
        } else {
            this.dummies.remove(this.mousePointer);
            this.mousePointer = null;
        }
        this.parent.mouseLock.unlock();
        if (backBufferGr != null) {
            int idx = 0;
            for (DummyPointer dp : this.dummies) {
                backBufferGr.clearRect(idx == this.activePointer ? 0 : 255, 0, 255, dp.x - 1, dp.y - 1, 3.0f, 3.0f);
                ++idx;
            }
            String status = "Pointer " + (this.activePointer + 1) + " of " + this.dummies.size();
            int statusLen = this.font.measureLine(status, false);
            backBufferGr.clearRect(0, 0, 0, 0.0f, 0.0f, statusLen, 16.0f);
            this.font.renderLine(status, 255, 255, 255, 255).renderRoot(backBufferGr, 0, 0);
        }
    }

    @Override
    public void performOffset(int x, int y) {
        this.offsetX += x;
        this.offsetY += y;
    }

    @Override
    public void clearOffset() {
        this.offsetX = 0;
        this.offsetY = 0;
        for (DummyPointer dp : this.dummies) {
            dp.ox = 0;
            dp.oy = 0;
        }
    }

    @Override
    public HashSet<IPointer> getActivePointers() {
        return new HashSet<IPointer>(this.dummies);
    }

    @Override
    public void clearKeys() {
        for (int p = 0; p < this.parent.keysjd.length; ++p) {
            this.parent.keysjd[p] = false;
            this.parent.keys[p] = false;
        }
        if (this.parent.currentEditingSession != null) {
            this.parent.currentEditingSession.endSession();
        }
    }

    @Override
    public ITextEditingSession openTextEditingSession(@NonNull String text, boolean multiLine, int textHeight, @Nullable Function<String, String> fun) {
        return this.parent.openEditingSession(this, text, multiLine, textHeight, fun);
    }

    @Override
    public String aroundTheBorderworldMaintain(TextboxMaintainer tm, int x, int y, int w, int h) {
        return tm.maintainActual((x - this.offsetX) * this.parent.sc, (y - this.offsetY) * this.parent.sc, w, h);
    }

    @Override
    public void finishRemovingEditingSession() {
        this.parent.currentEditingSession = null;
    }

    public static class DummyPointer
    implements IPointer {
        public int x;
        public int y;
        public int ox;
        public int oy;

        public DummyPointer(int mouseX, int mouseY) {
            this.x = mouseX;
            this.y = mouseY;
        }

        @Override
        public int getX() {
            return this.x + this.ox;
        }

        @Override
        public int getY() {
            return this.y + this.oy;
        }

        @Override
        public IPointer.PointerType getType() {
            return IPointer.PointerType.Generic;
        }

        @Override
        public void performOffset(int x, int y) {
            this.ox += x;
            this.oy += y;
        }
    }
}

