/*
 * Decompiled with CFR 0.152.
 */
package gabien;

import gabien.ClipboardImpl;
import gabien.GaBIEn;
import gabien.GaBIEnImpl;
import gabien.GaBIEnUI;
import gabien.GrInDriver;
import gabien.backend.EmulatedFileBrowser;
import gabien.backend.WindowMux;
import gabien.natives.BadGPU;
import gabien.natives.BadGPUEnum;
import gabien.natives.Loader;
import gabien.uslx.vfs.impl.JavaIOFSBackend;
import gabien.wsi.WindowSpecs;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

abstract class Main {
    private static boolean ignoreBlindingSun = false;

    Main() {
    }

    public static void main(String[] args) {
        try {
            Main.mainInner(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            StringWriter sw = new StringWriter();
            sw.append("The program was unable to start, or crashed while running.\nJVM: ");
            sw.append(System.getProperty("java.vendor"));
            sw.append(" ");
            sw.append(System.getProperty("java.vm.name"));
            sw.append(" ");
            sw.append(System.getProperty("java.vm.version"));
            sw.append(" ");
            sw.append(System.getProperty("os.arch"));
            sw.append(" ");
            sw.append(System.getProperty("os.name"));
            sw.append(" ");
            sw.append(System.getProperty("os.version"));
            sw.append("\nGaBIEn Natives version: ");
            try {
                sw.append(Loader.getNativesVersion());
            }
            catch (Throwable failed) {
                sw.append("[NOT INITIALIZED] ");
                try {
                    sw.append(Loader.defaultLoaderJavaSE() ? "[OK] " : "[FAIL] ");
                    sw.append(Loader.getNativesVersion());
                }
                catch (Throwable ex2) {
                    sw.append("[CATASTROPHIC FAILURE]");
                }
            }
            sw.append("\nRenderer: ");
            try {
                BadGPU.Instance bi = BadGPU.newInstance(0);
                String what = bi.getMetaInfo(BadGPUEnum.MetaInfoType.Renderer);
                bi.dispose();
                sw.append(what);
                sw.append(" [OK]\n");
            }
            catch (Throwable ex2) {
                sw.append("[FAIL]\n");
            }
            sw.append("\n");
            t.printStackTrace(new PrintWriter(sw));
            Frame f = new Frame("Graphics And Basic Input Engine");
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GaBIEn.ensureQuit();
                }
            });
            TextArea ta = new TextArea();
            ta.setText(sw.toString());
            f.add(ta);
            f.setSize(800, 600);
            f.setVisible(true);
        }
    }

    private static void mainInner(String[] args) throws Exception {
        boolean tryForceOpenGL = false;
        boolean ignoreDPI = false;
        boolean useInternalBrowser = false;
        boolean isTimeLogging = false;
        boolean isCrashingVopeks = false;
        int newInstanceFlags = 1 | GaBIEn.inferNewInstanceFlags();
        if (args.length > 0) {
            for (String s : args) {
                if (s.equalsIgnoreCase("forceOpenGL")) {
                    tryForceOpenGL = true;
                }
                if (s.equalsIgnoreCase("debug")) {
                    newInstanceFlags |= 6;
                }
                if (s.equalsIgnoreCase("stopImmediately")) {
                    throw new RuntimeException("stopImmediately passed on command line");
                }
                if (s.equalsIgnoreCase("crashVopeks")) {
                    isCrashingVopeks = true;
                }
                if (s.equalsIgnoreCase("timeLogger")) {
                    isTimeLogging = true;
                }
                if (s.equalsIgnoreCase("iAmARobot")) {
                    GaBIEnImpl.mobileEmulation = true;
                }
                if (s.equalsIgnoreCase("simAndroid23Init")) {
                    GaBIEnImpl.storagePermissionFlag = false;
                }
                if (s.equalsIgnoreCase("forceIgnoreDPI")) {
                    ignoreDPI = true;
                }
                if (s.equalsIgnoreCase("blindingSun")) {
                    ignoreBlindingSun = true;
                }
                if (s.equalsIgnoreCase("useInternalBrowser")) {
                    useInternalBrowser = true;
                }
                if (s.equalsIgnoreCase("swrForced")) {
                    newInstanceFlags |= 0x20;
                }
                if (!s.equalsIgnoreCase("swrRefused")) continue;
                newInstanceFlags |= 0x10;
            }
        }
        if (tryForceOpenGL) {
            System.setProperty("sun.java2d.opengl", "true");
            System.setProperty("sun.java2d.xrender", "true");
        }
        if (!ignoreDPI) {
            try {
                System.setProperty("sun.java2d.uiScale", "1");
                int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
                GrInDriver.uiGuessScaleTenths = (int)Math.max(10.0, Math.ceil((double)dpi / 9.6));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Main.initializeEmbedded(newInstanceFlags, isTimeLogging, isCrashingVopeks);
        if (GaBIEnImpl.mobileEmulation) {
            WindowSpecs ws = new WindowSpecs(GaBIEn.internal);
            ws.resizable = false;
            GaBIEn.internalWindowing = new WindowMux(GaBIEn.internal, GaBIEn.internalWindowing.makeGrIn("Mobile", 960, 540, ws));
            useInternalBrowser = true;
        }
        if (useInternalBrowser) {
            GaBIEn.internalFileBrowser = new EmulatedFileBrowser(GaBIEn.internal);
        }
        Class.forName("gabienapp.Application").getDeclaredMethod("gabienmain", new Class[0]).invoke(null, new Object[0]);
    }

    public static void initializeEmbedded() {
        Main.initializeEmbedded(GaBIEn.inferNewInstanceFlags(), false, false);
    }

    private static void initializeEmbedded(int newInstanceFlags, boolean isTimeLogging, boolean isCrashingVopeks) {
        if (!ignoreBlindingSun) {
            System.setProperty("sun.awt.noerasebackground", "true");
            System.setProperty("sun.awt.erasebackgroundonresize", "true");
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Font f = new Font("SansSerif", 0, 12);
                    BufferedImage scratch = new BufferedImage(1, 1, 5);
                    Graphics2D g = scratch.createGraphics();
                    g.setFont(f);
                    ((Graphics)g).drawString("Flutter", 0, 0);
                    System.err.println("FONT: Font has preloaded");
                }
                catch (Exception e) {
                    System.err.println("FONT: Font didn't preload, " + e);
                }
                GaBIEn.fontsReady = true;
            }
        }.start();
        GaBIEnImpl impl = new GaBIEnImpl();
        GaBIEn.internal = impl;
        GaBIEn.clipboard = new ClipboardImpl();
        GaBIEn.mutableDataFS = JavaIOFSBackend.from(new File("."));
        GaBIEn.internalWindowing = impl;
        GaBIEn.internalFileBrowser = (GaBIEnImpl)GaBIEn.internal;
        GaBIEn.setupNativesAndAssets(newInstanceFlags, isTimeLogging, isCrashingVopeks);
        GaBIEnUI.setupAssets();
    }
}

