/*
 * Decompiled with CFR 0.152.
 */
package gabien;

import gabien.ClipBoundHelper;
import gabien.DesktopPeripherals;
import gabien.GaBIEn;
import gabien.GaBIEnImpl;
import gabien.IGJSEPeripheralsInternal;
import gabien.MobilePeripherals;
import gabien.TextboxMaintainer;
import gabien.backend.WSIDownloadPair;
import gabien.natives.BadGPUEnum;
import gabien.natives.BadGPUUnsafe;
import gabien.render.IImage;
import gabien.wsi.IGrInDriver;
import gabien.wsi.IPeripherals;
import gabien.wsi.ITextEditingSession;
import gabien.wsi.WindowSpecs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.Panel;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JFrame;

class GrInDriver
implements IGrInDriver {
    public Frame frame;
    public Panel panel;
    public TextboxMaintainer currentEditingSession;
    public IGJSEPeripheralsInternal peripherals;
    public boolean[] keys = new boolean[94];
    public boolean[] keysjd = new boolean[94];
    public int sc;
    public static int uiGuessScaleTenths = 10;
    public ReentrantLock mouseLock = new ReentrantLock();
    public int mouseX = 0;
    public int mouseY = 0;
    public HashSet<Integer> mouseDown = new HashSet();
    public HashSet<Integer> mouseJustDown = new HashSet();
    public HashSet<Integer> mouseJustUp = new HashSet();
    public int mousewheelMovements = 0;
    public BufferedImage frontBuffer;
    public int wantedBackBufferW;
    public int wantedBackBufferH;
    private final DLIAPair dlIA;
    private final DLBIPair dlBI;
    public final KeyListener commonKeyListener;
    Random fuzzer = new Random();

    public GrInDriver(String name, WindowSpecs ws, int rw, int rh) {
        GraphicsDevice gd;
        if (rw < 1) {
            rw = 1;
        }
        if (rh < 1) {
            rh = 1;
        }
        this.sc = ws.scale;
        this.frame = new JFrame(name){

            @Override
            public void paint(Graphics graphics) {
                this.paintComponents(graphics);
            }
        };
        this.wantedBackBufferW = rw;
        this.wantedBackBufferH = rh;
        this.frontBuffer = new BufferedImage(rw * this.sc, rh * this.sc, 1);
        this.panel = new Panel(){

            @Override
            public void paint(Graphics graphics) {
                GrInDriver.this.drawFrontBuffer(graphics);
                this.paintComponents(graphics);
            }
        };
        this.frame.setResizable(ws.resizable && !ws.fullscreen);
        Color background = Color.black;
        if (ws.backgroundLight) {
            background = Color.white;
        }
        this.frame.setBackground(background);
        this.panel.setBackground(background);
        this.panel.setPreferredSize(new Dimension(rw * this.sc, rh * this.sc));
        this.frame.setSize(rw * this.sc, rh * this.sc);
        this.frame.add((Component)this.panel, "Center");
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.frame.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                for (int p = 0; p < GrInDriver.this.keys.length; ++p) {
                    GrInDriver.this.keys[p] = false;
                }
            }
        });
        this.panel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
                GrInDriver.this.mouseLock.lock();
                GrInDriver.this.mouseX = me.getX() / GrInDriver.this.sc;
                GrInDriver.this.mouseY = me.getY() / GrInDriver.this.sc;
                int mouseB = me.getButton();
                GrInDriver.this.mouseDown.add(mouseB);
                GrInDriver.this.mouseJustDown.add(mouseB);
                GrInDriver.this.mouseLock.unlock();
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                GrInDriver.this.mouseLock.lock();
                GrInDriver.this.mouseX = me.getX() / GrInDriver.this.sc;
                GrInDriver.this.mouseY = me.getY() / GrInDriver.this.sc;
                int mouseB = me.getButton();
                GrInDriver.this.mouseDown.remove(mouseB);
                GrInDriver.this.mouseJustUp.add(mouseB);
                GrInDriver.this.mouseLock.unlock();
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }
        });
        this.panel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent me) {
                GrInDriver.this.mouseLock.lock();
                GrInDriver.this.mouseX = me.getX() / GrInDriver.this.sc;
                GrInDriver.this.mouseY = me.getY() / GrInDriver.this.sc;
                GrInDriver.this.mouseLock.unlock();
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                GrInDriver.this.mouseLock.lock();
                GrInDriver.this.mouseX = me.getX() / GrInDriver.this.sc;
                GrInDriver.this.mouseY = me.getY() / GrInDriver.this.sc;
                if (GrInDriver.this.mouseDown.size() > 0) {
                    GrInDriver.this.mouseJustUp.addAll(GrInDriver.this.mouseDown);
                    GrInDriver.this.mouseDown.clear();
                }
                GrInDriver.this.mouseLock.unlock();
            }
        });
        this.panel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                GrInDriver.this.mouseLock.lock();
                GrInDriver.this.mousewheelMovements += mouseWheelEvent.getWheelRotation();
                GrInDriver.this.mouseLock.unlock();
            }
        });
        this.commonKeyListener = new KeyListener(){
            public int[] keymap = new int[]{27, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 45, 61, 8, 9, 81, 87, 69, 82, 84, 89, 85, 73, 79, 80, 91, 93, 10, 17, 65, 83, 68, 70, 71, 72, 74, 75, 76, 59, 222, 0, 16, 92, 90, 88, 67, 86, 66, 78, 77, 44, 46, 47, 0, 18, 32, 20, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 144, 145, 103, 104, 105, 0, 100, 101, 102, 0, 97, 98, 99, 96, 46, 122, 123, 0, 0, 65406, 0, 38, 37, 39, 40, 155, 127};

            @Override
            public void keyTyped(KeyEvent ke) {
            }

            public int filterKey(KeyEvent ke) {
                for (int p = 0; p < this.keymap.length; ++p) {
                    if (ke.getKeyCode() != this.keymap[p]) continue;
                    return p;
                }
                return -1;
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                int KeyNum = this.filterKey(ke);
                if (KeyNum != -1) {
                    if (!GrInDriver.this.keys[KeyNum]) {
                        GrInDriver.this.keysjd[KeyNum] = true;
                    }
                    GrInDriver.this.keys[KeyNum] = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent ke) {
                int KeyNum = this.filterKey(ke);
                if (KeyNum != -1) {
                    GrInDriver.this.keys[KeyNum] = false;
                }
            }
        };
        this.frame.addKeyListener(this.commonKeyListener);
        this.panel.addKeyListener(this.commonKeyListener);
        this.peripherals = GaBIEnImpl.mobileEmulation ? new MobilePeripherals(this) : new DesktopPeripherals(this);
        if (ws.fullscreen && (gd = GaBIEnImpl.getFSDevice()) != null) {
            gd.setFullScreenWindow(this.frame);
        }
        this.dlIA = new DLIAPair(name + ".dlIA");
        this.dlBI = new DLBIPair(name + ".dlBI");
        GaBIEnImpl.activeDriverLock.lock();
        GaBIEnImpl.activeDrivers.add(this);
        GaBIEnImpl.activeDriverLock.unlock();
    }

    @Override
    public int getWidth() {
        return this.wantedBackBufferW;
    }

    @Override
    public int getHeight() {
        return this.wantedBackBufferH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(IImage backBuffer) {
        GrInDriver grInDriver = this;
        synchronized (grInDriver) {
            if (this.peripherals instanceof MobilePeripherals) {
                ((MobilePeripherals)this.peripherals).mobilePeripheralsFinishFrame(backBuffer);
            }
            this.wantedBackBufferW = this.panel.getWidth() / this.sc;
            this.wantedBackBufferH = this.panel.getHeight() / this.sc;
        }
        backBuffer.batchFlush();
        GaBIEn.vopeks.putFinishTask();
        GaBIEn.vopeks.putBatchStatisticsTask();
        int[] ia = (int[])this.dlIA.acquire(backBuffer.width, backBuffer.height);
        backBuffer.getPixelsAsync(0, 0, backBuffer.width, backBuffer.height, BadGPUEnum.TextureLoadFormat.RGBA8888, ia, 0, () -> {
            if (backBuffer.width <= 0 || backBuffer.height <= 0) {
                this.dlIA.release(ia);
                return;
            }
            BadGPUUnsafe.pixelsConvertRGBX8888ToARGBI32InPlaceI(backBuffer.width, backBuffer.height, ia, 0);
            BufferedImage bi = (BufferedImage)this.dlBI.acquire(backBuffer.width, backBuffer.height);
            bi.getRaster().setDataElements(0, 0, backBuffer.width, backBuffer.height, ia);
            this.dlIA.release(ia);
            this.drawBackBufferToFrontBuffer(bi);
            this.dlBI.release(bi);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawBackBufferToFrontBuffer(BufferedImage backBufferBI) {
        GrInDriver grInDriver = this;
        synchronized (grInDriver) {
            int panelW = this.panel.getWidth();
            int panelH = this.panel.getHeight();
            if ((this.frontBuffer.getWidth() != panelW || this.frontBuffer.getHeight() != panelH) && panelW != 0 && panelH != 0) {
                this.frontBuffer = new BufferedImage(panelW, panelH, 1);
            }
            Graphics fbG = this.frontBuffer.getGraphics();
            if (backBufferBI != null) {
                fbG.drawImage(backBufferBI, 0, 0, backBufferBI.getWidth() * this.sc, backBufferBI.getHeight() * this.sc, null);
            }
        }
        grInDriver = this;
        synchronized (grInDriver) {
            this.drawFrontBuffer(this.panel.getGraphics());
        }
    }

    private synchronized void drawFrontBuffer(Graphics pg) {
        if (this.currentEditingSession != null) {
            JComponent target = this.currentEditingSession.placeComponent;
            int txX = target.getX();
            int txY = target.getY();
            int txW = target.getWidth();
            int txH = target.getHeight();
            ClipBoundHelper cbh = new ClipBoundHelper();
            cbh.point(0, 0);
            int fbW = this.frontBuffer.getWidth();
            int fbH = this.frontBuffer.getHeight();
            cbh.point(fbW, 0);
            cbh.point(0, fbH);
            cbh.point(-fbW, 0);
            cbh.point(0, txY - fbH);
            cbh.point(txX, 0);
            cbh.point(0, txH);
            cbh.point(txW, 0);
            cbh.point(0, -txH);
            cbh.point(-(txX + txW), 0);
            pg.setClip(cbh.p);
            pg.drawImage(this.frontBuffer, 0, 0, null);
            pg.setClip(null);
        } else {
            pg.setClip(null);
            pg.drawImage(this.frontBuffer, 0, 0, null);
        }
    }

    @Override
    public IPeripherals getPeripherals() {
        return this.peripherals;
    }

    @Override
    public boolean stillRunning() {
        boolean res = this.frame.isVisible();
        if (!res) {
            this.shutdown();
        }
        return res;
    }

    @Override
    public synchronized void shutdown() {
        GaBIEnImpl.activeDriverLock.lock();
        GaBIEnImpl.lastClosureDevice = this.frame.getGraphicsConfiguration().getDevice();
        GaBIEnImpl.activeDrivers.remove(this);
        GaBIEnImpl.activeDriverLock.unlock();
        this.frame.setVisible(false);
    }

    private void fuzzXY() {
        this.mouseX += this.fuzzer.nextInt(17) - 8;
        this.mouseY += this.fuzzer.nextInt(17) - 8;
    }

    @Override
    public int estimateUIScaleTenths() {
        return uiGuessScaleTenths;
    }

    public ITextEditingSession openEditingSession(IGJSEPeripheralsInternal peripheralsInternal, String text, boolean multiLine, int textHeight, Function<String, String> fun) {
        if (this.currentEditingSession != null) {
            this.currentEditingSession.endSession();
        }
        this.currentEditingSession = new TextboxMaintainer(peripheralsInternal, this.panel, this.commonKeyListener, multiLine, textHeight, fun, text);
        return this.currentEditingSession;
    }

    private class DLBIPair
    extends WSIDownloadPair<BufferedImage> {
        public DLBIPair(String n) {
            super(n, 1);
        }

        @Override
        public boolean bufferMatchesSize(BufferedImage buffer, int width, int height) {
            return buffer.getWidth() == width && buffer.getHeight() == height;
        }

        @Override
        public BufferedImage genBuffer(int width, int height) {
            return new BufferedImage(width, height, 3);
        }
    }

    private class DLIAPair
    extends WSIDownloadPair<int[]> {
        public DLIAPair(String n) {
            super(n, 3);
        }

        @Override
        public boolean bufferMatchesSize(int[] buffer, int width, int height) {
            return buffer.length == width * height;
        }

        @Override
        public int[] genBuffer(int width, int height) {
            return new int[width * height];
        }
    }
}

