/*
 * Decompiled with CFR 0.152.
 */
package gabien;

import gabien.AWTTypeface;
import gabien.AWTWSIImage;
import gabien.GaBIEn;
import gabien.GrInDriver;
import gabien.RawSoundDriver;
import gabien.audio.IRawAudioDriver;
import gabien.backend.IGaBIEn;
import gabien.backend.IGaBIEnFileBrowser;
import gabien.backend.IGaBIEnMultiWindow;
import gabien.render.WSIImage;
import gabien.text.ITypeface;
import gabien.wsi.IGrInDriver;
import gabien.wsi.WindowSpecs;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.sound.sampled.LineUnavailableException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GaBIEnImpl
implements IGaBIEn,
IGaBIEnMultiWindow,
IGaBIEnFileBrowser {
    public static boolean mobileEmulation;
    public static boolean storagePermissionFlag;
    protected static int uiGuessScaleTenths;
    public static boolean fontsAlwaysMeasure16;
    protected static ReentrantLock activeDriverLock;
    protected static HashSet<GrInDriver> activeDrivers;
    protected static GraphicsDevice lastClosureDevice;
    private RawSoundDriver sound = null;
    private String fbDirectory = ".";

    protected static GraphicsDevice getFSDevice() {
        activeDriverLock.lock();
        for (GrInDriver igd : activeDrivers) {
            GraphicsDevice gd = igd.frame.getGraphicsConfiguration().getDevice();
            if (gd == null || !gd.isFullScreenSupported()) continue;
            activeDriverLock.unlock();
            return gd;
        }
        if (lastClosureDevice != null && lastClosureDevice.isFullScreenSupported()) {
            activeDriverLock.unlock();
            return lastClosureDevice;
        }
        activeDriverLock.unlock();
        GraphicsDevice[] devs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devs.length == 0) {
            return null;
        }
        for (int i = 0; i < devs.length; ++i) {
            if (!devs[i].isFullScreenSupported()) continue;
            return devs[i];
        }
        return null;
    }

    @Override
    public InputStream getResource(String resource) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream("assets/" + resource);
    }

    @Override
    public IGrInDriver makeGrIn(String name, int w, int h, WindowSpecs ws) {
        return new GrInDriver(name, ws, w, h);
    }

    @Override
    public boolean isActuallySingleWindow() {
        return false;
    }

    @Override
    public void ensureQuit() {
        System.exit(0);
    }

    @Override
    public IRawAudioDriver getRawAudio() {
        if (this.sound == null) {
            try {
                this.sound = new RawSoundDriver();
            }
            catch (LineUnavailableException ex) {
                Logger.getLogger(GaBIEnImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.sound;
    }

    @Override
    public void hintShutdownRawAudio() {
        if (this.sound != null) {
            this.sound.shutdown();
        }
        this.sound = null;
    }

    @Override
    public WindowSpecs defaultWindowSpecs(String name, int w, int h) {
        WindowSpecs ws = new WindowSpecs(this);
        ws.scale = w > 400 || h > 300 ? 1 : 2;
        ws.resizable = false;
        return ws;
    }

    @Override
    @Nullable
    public WSIImage decodeWSIImage(@NonNull InputStream a) {
        try {
            BufferedImage bi = ImageIO.read(a);
            if (bi.getType() == 2) {
                return new AWTWSIImage(bi);
            }
            int[] tmp = new int[bi.getWidth() * bi.getHeight()];
            bi.getRGB(0, 0, bi.getWidth(), bi.getHeight(), tmp, 0, bi.getWidth());
            return new AWTWSIImage(tmp, bi.getWidth(), bi.getHeight());
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public WSIImage.RW createWSIImage(@NonNull int[] colours, int width, int height) {
        return new AWTWSIImage(colours, width, height);
    }

    public static String getDefaultFont() {
        return "SansSerif";
    }

    @Override
    @NonNull
    public String getDefaultNativeFontName() {
        return GaBIEnImpl.getDefaultFont();
    }

    @Override
    @NonNull
    public ITypeface getDefaultTypeface() {
        return AWTTypeface.getDefaultTypeface();
    }

    @Override
    @Nullable
    public ITypeface getNativeTypeface(@NonNull String name) {
        return AWTTypeface.getTypeface(name);
    }

    @Override
    public String[] getFontOverrides() {
        String[] p = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        boolean foundFirst = false;
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].equals(GaBIEnImpl.getDefaultFont())) continue;
            foundFirst = true;
            if (i == 0) break;
            String x = p[0];
            p[0] = GaBIEnImpl.getDefaultFont();
            p[i] = x;
            break;
        }
        if (!foundFirst) {
            String[] p2 = new String[p.length + 1];
            p2[0] = GaBIEnImpl.getDefaultFont();
            System.arraycopy(p, 0, p2, 1, p.length);
            return p2;
        }
        return p;
    }

    @Override
    public boolean tryStartTextEditor(String fpath) {
        try {
            Desktop.getDesktop().open(new File(fpath));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean tryStartBrowser(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void setBrowserDirectory(String b) {
        if (b.isEmpty()) {
            b = ".";
        }
        this.fbDirectory = b;
    }

    @Override
    public void startFileBrowser(String text, boolean saving, String exts, final Consumer<String> result, String initialName) {
        Frame f = null;
        GraphicsDevice gd = GaBIEnImpl.getFSDevice();
        if (gd != null) {
            activeDriverLock.lock();
            for (GrInDriver gid : activeDrivers) {
                if (gd.getFullScreenWindow() != gid.frame) continue;
                f = gid.frame;
            }
            activeDriverLock.unlock();
        }
        final FileDialog fd = new FileDialog(f, text);
        fd.setDirectory(this.fbDirectory);
        fd.setFile(exts);
        fd.setMode(saving ? 1 : 0);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                fd.setVisible(true);
                String f = fd.getFile();
                final String fdr = fd.getDirectory();
                final String fs = f == null ? null : fd.getDirectory() + f;
                GaBIEn.pushCallback(new Runnable(){

                    @Override
                    public void run() {
                        if (fdr != null) {
                            GaBIEnImpl.this.fbDirectory = fdr;
                        }
                        result.accept(fs);
                    }
                });
            }
        });
    }

    @Override
    public boolean hasStoragePermission() {
        return storagePermissionFlag;
    }

    static {
        storagePermissionFlag = true;
        uiGuessScaleTenths = 10;
        activeDriverLock = new ReentrantLock();
        activeDrivers = new HashSet();
        lastClosureDevice = null;
    }
}

