/*
 * Decompiled with CFR 0.152.
 */
package gabien;

import gabien.audio.IRawAudioDriver;
import gabien.backend.IGaBIEn;
import gabien.backend.IGaBIEnFileBrowser;
import gabien.backend.IGaBIEnMultiWindow;
import gabien.backend.ImageCache;
import gabien.backend.NativeFontCache;
import gabien.backend.NullGrDriver;
import gabien.natives.BadGPUEnum;
import gabien.natives.Loader;
import gabien.render.IGrDriver;
import gabien.render.IImage;
import gabien.render.WSIImage;
import gabien.text.EngineFonts;
import gabien.text.IFixedSizeFont;
import gabien.uslx.append.AssetFS;
import gabien.uslx.append.TimeLogger;
import gabien.uslx.vfs.FSBackend;
import gabien.vopeks.Vopeks;
import gabien.vopeks.VopeksBatchingSurface;
import gabien.vopeks.VopeksImage;
import gabien.vopeks.VopeksUnbatchingSurface;
import gabien.wsi.IGaBIEnClipboard;
import gabien.wsi.IGrInDriver;
import gabien.wsi.WindowSpecs;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GaBIEn {
    public static Vopeks vopeks;
    public static TimeLogger timeLogger;
    public static IGaBIEnClipboard clipboard;
    public static FSBackend mutableDataFS;
    public static volatile boolean fontsReady;
    static IGaBIEn internal;
    static IGaBIEnMultiWindow internalWindowing;
    static IGaBIEnFileBrowser internalFileBrowser;
    public static EngineFonts engineFonts;
    private static IImage errorImage;
    private static ReentrantLock callbackQueueLock;
    private static LinkedList<Runnable> callbackQueue;
    private static LinkedList<Runnable> callbacksToAddAfterCallbacksQueue;
    private static NativeFontCache nativeFontCache;
    private static ImageCache imageCache;
    public static String[] appPrefixes;
    public static String wordSave;
    public static String wordLoad;
    public static String wordInvalidFileName;
    public static int sysCoreFontSize;
    private static double lastDt;
    private static long startup;

    private GaBIEn() {
    }

    public static double getTime() {
        return (double)(System.currentTimeMillis() - startup) / 1000.0;
    }

    public static double timeDelta(boolean reset) {
        double recording = GaBIEn.getTime();
        double dt = recording - lastDt;
        if (reset) {
            lastDt = recording;
        }
        return dt;
    }

    @Nullable
    public static InputStream getResource(@NonNull String resource) {
        for (String s : appPrefixes) {
            InputStream inp = GaBIEn.getInFile(s + resource);
            if (inp == null) continue;
            return inp;
        }
        return internal.getResource(resource);
    }

    @Nullable
    public static InputStreamReader getTextResource(@NonNull String resource) {
        InputStream inp = GaBIEn.getResource(resource);
        if (inp == null) {
            return null;
        }
        return new InputStreamReader(inp, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getTextResourceAsString(@NonNull String resource) {
        try (InputStreamReader isr = GaBIEn.getTextResource(resource);){
            if (isr == null) {
                String string2 = null;
                return string2;
            }
            StringBuilder sb = new StringBuilder();
            while (true) {
                int i;
                if ((i = isr.read()) == -1) {
                    String string = sb.toString();
                    return string;
                }
                sb.append((char)i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static InputStream getInFile(@NonNull String name) {
        return GaBIEn.getInFile(mutableDataFS.intoPath(name));
    }

    @NonNull
    public static InputStream getInFileOrThrow(@NonNull String name) throws IOException {
        return mutableDataFS.intoPath(name).openRead();
    }

    @Nullable
    public static InputStream getInFile(@NonNull FSBackend name) {
        try {
            return name.openRead();
        }
        catch (Exception ioe) {
            return null;
        }
    }

    @Nullable
    public static OutputStream getOutFile(@NonNull String name) {
        return GaBIEn.getOutFile(mutableDataFS.intoPath(name));
    }

    @NonNull
    public static OutputStream getOutFileOrThrow(@NonNull String name) throws IOException {
        return mutableDataFS.intoPath(name).openWrite();
    }

    @Nullable
    public static OutputStream getOutFile(@NonNull FSBackend node) {
        try {
            return node.openWrite();
        }
        catch (Exception ioe) {
            return null;
        }
    }

    public static boolean singleWindowApp() {
        return internalWindowing.isActuallySingleWindow();
    }

    @NonNull
    public static IRawAudioDriver getRawAudio() {
        return internal.getRawAudio();
    }

    public static void hintShutdownRawAudio() {
        internal.hintShutdownRawAudio();
    }

    public static void ensureQuit() {
        try {
            if (timeLogger != null) {
                timeLogger.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        internal.ensureQuit();
    }

    @NonNull
    public static WindowSpecs defaultWindowSpecs(@NonNull String name, int w, int h) {
        return internalWindowing.defaultWindowSpecs(name, w, h);
    }

    @NonNull
    public static IGrInDriver makeGrIn(@NonNull String name, int w, int h) {
        WindowSpecs ws = GaBIEn.defaultWindowSpecs(name, w, h);
        return GaBIEn.makeGrIn(name, w, h, ws);
    }

    @NonNull
    public static IGrInDriver makeGrIn(String name, int w, int h, @NonNull WindowSpecs specs) {
        return internalWindowing.makeGrIn(name, w, h, specs);
    }

    @NonNull
    public static IGrDriver makeOffscreenBuffer(int width, int height) {
        return GaBIEn.makeOffscreenBuffer(width, height, null);
    }

    @NonNull
    public static IGrDriver makeOffscreenBuffer(int width, int height, @Nullable String id) {
        if (width <= 0) {
            return new NullGrDriver();
        }
        if (height <= 0) {
            return new NullGrDriver();
        }
        return new VopeksBatchingSurface(vopeks, id, width, height, null, 65536);
    }

    @NonNull
    public static IGrDriver makeAtlasPage(int width, int height) {
        return GaBIEn.makeAtlasPage(width, height, null);
    }

    @NonNull
    public static IGrDriver makeAtlasPage(int width, int height, @Nullable String id) {
        if (width <= 0) {
            return new NullGrDriver();
        }
        if (height <= 0) {
            return new NullGrDriver();
        }
        return new VopeksUnbatchingSurface(vopeks, id, width, height, null);
    }

    @NonNull
    public static IImage getImage(String a) {
        return GaBIEn.getImageEx(a, true, true);
    }

    @NonNull
    public static IImage getImageCK(@NonNull String a, int r, int g, int b) {
        return GaBIEn.getImageCKEx(a, true, true, r, g, b);
    }

    @NonNull
    public static IImage getImageEx(@NonNull String a, boolean fs, boolean res) {
        IImage iImage;
        IImage err = GaBIEn.getErrorImage();
        if (fs && (iImage = imageCache.getImage(a, false)) != err) {
            return iImage;
        }
        if (res) {
            for (String s : appPrefixes) {
                IImage r2 = imageCache.getImage(s + a, false);
                if (r2 == err) continue;
                return r2;
            }
            IImage iImage2 = imageCache.getImage(a, true);
            if (iImage2 == err) {
                System.err.println("GaBIEn: Couldn't get: " + a + " (" + fs + ", " + res + ")");
            }
            return iImage2;
        }
        System.err.println("GaBIEn: Couldn't get: " + a + " (" + fs + ", " + res + ")");
        return err;
    }

    @Nullable
    public static WSIImage getWSIImage(@NonNull String a, boolean fs, boolean res) {
        WSIImage wSIImage;
        if (fs && (wSIImage = imageCache.getWSIImage(a, false)) != null) {
            return wSIImage;
        }
        if (res) {
            for (String s : appPrefixes) {
                WSIImage r2 = imageCache.getWSIImage(s + a, false);
                if (r2 == null) continue;
                return r2;
            }
            WSIImage wSIImage2 = imageCache.getWSIImage(a, true);
            if (wSIImage2 == null) {
                System.err.println("GaBIEn: Couldn't get: " + a + " (" + fs + ", " + res + ")");
            }
            return wSIImage2;
        }
        System.err.println("GaBIEn: Couldn't get: " + a + " (" + fs + ", " + res + ")");
        return null;
    }

    @NonNull
    public static IImage getImageCKEx(@NonNull String a, boolean fs, boolean res, int r, int g, int b) {
        IImage iImage;
        IImage err = GaBIEn.getErrorImage();
        if (fs && (iImage = imageCache.getImageCK(a, false, r, g, b)) != err) {
            return iImage;
        }
        if (res) {
            for (String s : appPrefixes) {
                IImage ri2 = imageCache.getImageCK(s + a, false, r, g, b);
                if (ri2 == err) continue;
                return ri2;
            }
            IImage iImage2 = imageCache.getImageCK(a, true, r, g, b);
            if (iImage2 == err) {
                System.err.println("GaBIEn: Couldn't get: " + a + " (" + fs + ", " + res + ")");
            }
            return iImage2;
        }
        System.err.println("GaBIEn: Couldn't get: " + a + " (" + fs + ", " + res + ")");
        return err;
    }

    public static IImage wsiToCK(@Nullable String name, @NonNull WSIImage img, int tr, int tg, int tb) {
        int colourKey = tb | tg << 8 | tr << 16;
        return new VopeksImage(vopeks, name, img.width, img.height, consumer -> vopeks.putTask(instance -> {
            int[] data = img.getPixels();
            for (int i = 0; i < data.length; ++i) {
                int c = data[i];
                data[i] = (c & 0xFFFFFF) != colourKey ? c | 0xFF000000 : 0;
            }
            consumer.accept(instance.newTexture(img.width, img.height, BadGPUEnum.TextureLoadFormat.ARGBI32_SA, data, 0));
        }));
    }

    @NonNull
    public static IImage getErrorImage() {
        return errorImage;
    }

    @NonNull
    public static IImage createImage(@NonNull int[] colours, int width, int height) {
        return GaBIEn.createImage(null, colours, width, height);
    }

    @NonNull
    public static IImage createImage(@Nullable String debugId, @NonNull int[] colours, int width, int height) {
        if (width <= 0) {
            return new NullGrDriver();
        }
        if (height <= 0) {
            return new NullGrDriver();
        }
        return new VopeksImage(vopeks, debugId, width, height, BadGPUEnum.TextureLoadFormat.ARGBI32_SA, colours);
    }

    @NonNull
    public static WSIImage.RW createWSIImage(@NonNull int[] colours, int width, int height) {
        return internal.createWSIImage(colours, width, height);
    }

    @Nullable
    public static WSIImage decodeWSIImage(@NonNull InputStream a) {
        return internal.decodeWSIImage(a);
    }

    public static void hintFlushAllTheCaches() {
        imageCache.hintFlushAllTheCaches();
    }

    @NonNull
    public static String getDefaultNativeFontName() {
        return internal.getDefaultNativeFontName();
    }

    @NonNull
    public static String[] getFontOverrides() {
        return internal.getFontOverrides();
    }

    @Nullable
    public static IFixedSizeFont getNativeFont(int size, @Nullable String name, boolean fallback) {
        return GaBIEn.getNativeFont(size, 0, name, fallback);
    }

    @Nullable
    public static IFixedSizeFont getNativeFont(int size, int style, @Nullable String name, boolean fallback) {
        if (name == null) {
            return nativeFontCache.getDefaultNativeFont(size, style);
        }
        IFixedSizeFont tmp = nativeFontCache.getNativeFont(size, style, name);
        if (tmp == null && fallback) {
            return nativeFontCache.getDefaultNativeFont(size, style);
        }
        return tmp;
    }

    @NonNull
    public static IFixedSizeFont getNativeFontFallback(int size, @Nullable String name) {
        return GaBIEn.getNativeFontFallback(size, 0, name);
    }

    @NonNull
    public static IFixedSizeFont getNativeFontFallback(int size, int style, @Nullable String name) {
        if (name == null) {
            return nativeFontCache.getDefaultNativeFont(size, style);
        }
        IFixedSizeFont nf = nativeFontCache.getNativeFont(size, style, name);
        if (nf == null) {
            return nativeFontCache.getDefaultNativeFont(size, style);
        }
        return nf;
    }

    public static boolean fileOrDirExists(@NonNull String s) {
        return mutableDataFS.intoPath(s).getState() != null;
    }

    public static boolean dirExists(@NonNull String s) {
        return mutableDataFS.intoPath(s).isDirectory();
    }

    @Nullable
    public static String[] listEntries(@NonNull String s) {
        return GaBIEn.listEntries(mutableDataFS.intoPath(s));
    }

    @Nullable
    public static String[] listEntries(@NonNull FSBackend s) {
        FSBackend.XState xs = s.getState();
        if (xs instanceof FSBackend.DirectoryState) {
            return ((FSBackend.DirectoryState)xs).entries;
        }
        return null;
    }

    @NonNull
    public static String absolutePathOf(@NonNull String s) {
        return mutableDataFS.intoPath(s).getAbsolutePath();
    }

    @NonNull
    public static String nameOf(@NonNull String s) {
        return GaBIEn.mutableDataFS.pathModel.nameOf(s);
    }

    @Nullable
    public static String parentOf(@NonNull String s) {
        FSBackend fsb = GaBIEn.mutableDataFS.intoPath((String)s).parent;
        if (fsb == null) {
            return null;
        }
        return fsb.getAbsolutePath();
    }

    public static void makeDirectories(@NonNull String s) {
        mutableDataFS.intoPath(s).mkdirs();
    }

    public static boolean tryStartTextEditor(@NonNull String fpath) {
        return internal.tryStartTextEditor(fpath);
    }

    public static boolean tryStartBrowser(@NonNull String url) {
        return internal.tryStartBrowser(url);
    }

    public static void rmFile(@NonNull String s) {
        try {
            mutableDataFS.intoPath(s).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setBrowserDirectory(@NonNull String s) {
        internalFileBrowser.setBrowserDirectory(s);
    }

    public static void startFileBrowser(String s, boolean saving, String exts, Consumer<String> iConsumer) {
        internalFileBrowser.startFileBrowser(s, saving, exts, iConsumer, "");
    }

    public static void startFileBrowser(String s, boolean saving, String exts, Consumer<String> iConsumer, String initialName) {
        internalFileBrowser.startFileBrowser(s, saving, exts, iConsumer, initialName);
    }

    public static boolean hasStoragePermission() {
        return internal.hasStoragePermission();
    }

    public static int getLoadedClassCount() {
        try {
            Method m = Class.forName("java.lang.management.ManagementFactory").getMethod("getClassLoadingMXBean", new Class[0]);
            Object classLoadingMXBean = m.invoke(null, new Object[0]);
            return (Integer)Class.forName("java.lang.management.ClassLoadingMXBean").getMethod("getLoadedClassCount", new Class[0]).invoke(classLoadingMXBean, new Object[0]);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static void pushCallback(Runnable r) {
        callbackQueueLock.lock();
        callbackQueue.add(r);
        callbackQueueLock.unlock();
    }

    public static void pushLaterCallback(Runnable runnable) {
        callbackQueueLock.lock();
        callbacksToAddAfterCallbacksQueue.add(runnable);
        callbackQueueLock.unlock();
    }

    public static void runCallbacks() {
        callbackQueueLock.lock();
        while (callbackQueue.size() > 0) {
            callbackQueueLock.unlock();
            callbackQueue.removeFirst().run();
            callbackQueueLock.lock();
        }
        callbackQueue.addAll(callbacksToAddAfterCallbacksQueue);
        callbacksToAddAfterCallbacksQueue.clear();
        callbackQueueLock.unlock();
    }

    public static double endFrame(double dTTarg) {
        GaBIEn.runCallbacks();
        double dT = GaBIEn.timeDelta(false);
        while (dT < dTTarg) {
            try {
                long ofs = (long)((dTTarg - dT) * 1000.0);
                if (ofs > 0L) {
                    Thread.sleep(ofs);
                } else {
                    Thread.yield();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            dT = GaBIEn.timeDelta(false);
        }
        return GaBIEn.timeDelta(true);
    }

    public static void initializeEmbedded() {
        try {
            Class.forName("gabien.Main").getDeclaredMethod("initializeEmbedded", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static int inferNewInstanceFlags() {
        if (System.getenv("BADGPU_EGL_LIBRARY") != null) {
            return 8;
        }
        return 0;
    }

    static void setupNativesAndAssetsForTests() {
        GaBIEn.setupNativesAndAssets(GaBIEn.inferNewInstanceFlags() | 1 | 2 | 4, false, false);
    }

    static void setupNativesAndAssets(int newInstanceFlags, boolean setupTimeLogger, boolean isCrashingVopeks) {
        try {
            String[] str = (String[])Class.forName("gabienapp.Application").getField("appPrefixes").get(null);
            appPrefixes = str;
            StringBuilder sb = new StringBuilder();
            sb.append("GaBIEn: Successfully set app resource prefixes to:");
            for (String s : appPrefixes) {
                sb.append(" \"");
                sb.append(s);
                sb.append("\"");
            }
            System.err.println(sb.toString());
        }
        catch (Exception str) {
            // empty catch block
        }
        AssetFS.READER = GaBIEn::getResource;
        if (setupTimeLogger && timeLogger == null) {
            timeLogger = new TimeLogger(GaBIEn.getOutFile("gTimeLogger.bin"));
        }
        if (vopeks == null) {
            if (!Loader.defaultLoader(GaBIEn::getResource, internal::nativeDestinationSetup)) {
                System.err.println("GaBIEn: Natives did not initialize. And before it gets better, it's getting worse...");
            }
            System.err.println("GaBIEn: Natives: " + Loader.getNativesVersion());
            vopeks = new Vopeks(newInstanceFlags, timeLogger, isCrashingVopeks);
            while (!GaBIEn.vopeks.initComplete.get()) {
            }
            Throwable t = GaBIEn.vopeks.initFailure.get();
            if (t != null) {
                throw new RuntimeException("Error during VOPEKS init; check console for BadGPU error messages", t);
            }
            errorImage = GaBIEn.createImage("getErrorImage", new int[]{-65281, -65281, -65281, -65281, -16777216, -16777216, -16777216, -16777216, -65281, -65281, -65281, -65281, -16777216, -16777216, -16777216, -16777216, -65281, -65281, -65281, -65281, -16777216, -16777216, -16777216, -16777216, -65281, -65281, -65281, -65281, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -65281, -65281, -65281, -65281, -16777216, -16777216, -16777216, -16777216, -65281, -65281, -65281, -65281, -16777216, -16777216, -16777216, -16777216, -65281, -65281, -65281, -65281, -16777216, -16777216, -16777216, -16777216, -65281, -65281, -65281, -65281}, 8, 8);
        }
        nativeFontCache = new NativeFontCache(internal);
        imageCache = new ImageCache(internal);
        engineFonts = new EngineFonts(internal);
    }

    public static void verify(IGaBIEn engine) {
        if (internal != engine) {
            throw new RuntimeException("Attempt to falsify engine permissions.");
        }
    }

    static {
        callbackQueueLock = new ReentrantLock();
        callbackQueue = new LinkedList();
        callbacksToAddAfterCallbacksQueue = new LinkedList();
        appPrefixes = new String[0];
        wordSave = "Save";
        wordLoad = "Load";
        wordInvalidFileName = "Invalid or missing file name.";
        sysCoreFontSize = 8;
        startup = System.currentTimeMillis();
    }
}

