/*
 * Decompiled with CFR 0.152.
 */
package gabien;

import gabien.GrInDriver;
import gabien.IGJSEPeripheralsInternal;
import gabien.MousePointer;
import gabien.TextboxMaintainer;
import gabien.wsi.IDesktopPeripherals;
import gabien.wsi.IPointer;
import gabien.wsi.ITextEditingSession;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class DesktopPeripherals
implements IDesktopPeripherals,
IGJSEPeripheralsInternal {
    private final GrInDriver parent;
    private int offsetX;
    private int offsetY;
    private HashMap<Integer, MousePointer> activePointers = new HashMap();

    public DesktopPeripherals(GrInDriver par) {
        this.parent = par;
    }

    @Override
    public int getMouseX() {
        return this.parent.mouseX + this.offsetX;
    }

    @Override
    public int getMouseY() {
        return this.parent.mouseY + this.offsetY;
    }

    @Override
    public int getMousewheelBuffer() {
        this.parent.mouseLock.lock();
        int d = this.parent.mousewheelMovements;
        if (d < 0) {
            d = -1;
            ++this.parent.mousewheelMovements;
        } else if (d > 0) {
            d = 1;
            --this.parent.mousewheelMovements;
        }
        this.parent.mouseLock.unlock();
        return d;
    }

    @Override
    public boolean isKeyDown(int key) {
        return this.parent.keys[key];
    }

    @Override
    public boolean isKeyJustPressed(int KEYID) {
        boolean b = this.parent.keysjd[KEYID];
        this.parent.keysjd[KEYID] = false;
        return b;
    }

    @Override
    public void clearKeys() {
        for (int p = 0; p < this.parent.keysjd.length; ++p) {
            this.parent.keysjd[p] = false;
            this.parent.keys[p] = false;
        }
        this.parent.mouseLock.lock();
        this.parent.mouseJustDown.clear();
        this.parent.mouseJustUp.clear();
        this.parent.mouseLock.unlock();
        if (this.parent.currentEditingSession != null) {
            this.parent.currentEditingSession.endSession();
        }
    }

    @Override
    public HashSet<Integer> activeKeys() {
        HashSet<Integer> keysH = new HashSet<Integer>();
        for (int i = 0; i < this.parent.keys.length; ++i) {
            if (!this.parent.keys[i]) continue;
            keysH.add(i);
        }
        return keysH;
    }

    @Override
    public ITextEditingSession openTextEditingSession(@NonNull String text, boolean multiLine, int textHeight, @Nullable Function<String, String> fun) {
        return this.parent.openEditingSession(this, text, multiLine, textHeight, fun);
    }

    @Override
    public String aroundTheBorderworldMaintain(TextboxMaintainer tm, int x, int y, int w, int h) {
        return tm.maintainActual((x - this.offsetX) * this.parent.sc, (y - this.offsetY) * this.parent.sc, w * this.parent.sc, h * this.parent.sc);
    }

    @Override
    public void finishRemovingEditingSession() {
        this.parent.currentEditingSession = null;
    }

    @Override
    public void performOffset(int x, int y) {
        this.offsetX += x;
        this.offsetY += y;
    }

    @Override
    public void clearOffset() {
        this.offsetX = 0;
        this.offsetY = 0;
        for (MousePointer mp : this.activePointers.values()) {
            mp.flushOffset();
        }
    }

    @Override
    public HashSet<IPointer> getActivePointers() {
        this.parent.mouseLock.lock();
        HashSet<Integer> effectiveDown = new HashSet<Integer>(this.parent.mouseDown);
        effectiveDown.addAll(this.parent.mouseJustDown);
        this.parent.mouseJustDown.clear();
        for (Integer i : new HashSet<Integer>(this.activePointers.keySet())) {
            if (effectiveDown.contains(i)) continue;
            this.activePointers.remove(i);
        }
        HashSet<IPointer> f = new HashSet<IPointer>();
        for (Integer i : effectiveDown) {
            MousePointer mp = this.activePointers.get(i);
            if (mp == null) {
                mp = new MousePointer(this.parent);
                mp.button = i;
                this.activePointers.put(i, mp);
            }
            f.add(mp);
        }
        this.parent.mouseLock.unlock();
        return f;
    }
}

