/*
 * Decompiled with CFR 0.152.
 */
package gabien;

import gabien.GaBIEn;
import gabien.render.WSIImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AWTWSIImage
extends WSIImage.RW {
    @Nullable
    public final BufferedImage buf;
    @Nullable
    public final WritableRaster bufWR;

    public AWTWSIImage(@NonNull BufferedImage bi) {
        super(GaBIEn.internal, bi.getWidth(), bi.getHeight());
        if (bi.getType() != 2) {
            throw new IllegalArgumentException("The passed BufferedImage must be TYPE_INT_ARGB");
        }
        this.buf = bi;
        this.bufWR = bi.getRaster();
    }

    public AWTWSIImage(@Nullable int[] colours, int width, int height) {
        super(GaBIEn.internal, width < 0 ? 0 : width, height < 0 ? 0 : height);
        if (width <= 0 || height <= 0) {
            this.buf = null;
            this.bufWR = null;
        } else {
            this.buf = new BufferedImage(width, height, 2);
            this.bufWR = this.buf.getRaster();
            if (colours != null) {
                this.bufWR.setDataElements(0, 0, width, height, colours);
            }
        }
    }

    @Override
    public void getPixels(@NonNull int[] colours) {
        if (this.bufWR != null) {
            this.bufWR.getDataElements(0, 0, this.buf.getWidth(), this.buf.getHeight(), colours);
        }
    }

    @Override
    public void setPixels(@NonNull int[] colours) {
        if (this.bufWR != null) {
            this.bufWR.setDataElements(0, 0, this.buf.getWidth(), this.buf.getHeight(), colours);
        }
    }

    @Override
    @NonNull
    public byte[] createPNG() {
        if (this.buf == null) {
            return GaBIEn.createWSIImage(new int[1], 1, 1).createPNG();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.buf, "PNG", baos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }
}

