/*
 * Decompiled with CFR 0.152.
 */
package gabien;

import gabien.AWTNativeFont;
import gabien.GaBIEn;
import gabien.GaBIEnImpl;
import gabien.text.IFixedSizeFont;
import gabien.text.ITypeface;
import java.awt.Font;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AWTTypeface
implements ITypeface {
    public final Font fontPlain;

    public AWTTypeface(Font fontPlain) {
        this.fontPlain = fontPlain;
    }

    @NonNull
    public static ITypeface getDefaultTypeface() {
        try {
            return new AWTTypeface(new Font(GaBIEnImpl.getDefaultFont(), 0, 1));
        }
        catch (Exception exception) {
            System.err.println("AWTNativeFont failed to get fallback font, so an engine default was used.");
            return GaBIEn.engineFonts;
        }
    }

    @Nullable
    public static ITypeface getTypeface(String s) {
        try {
            return new AWTTypeface(new Font(s, 0, 1));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @NonNull
    public IFixedSizeFont derive(int size, int style) {
        float szf = size - size / 8;
        return new AWTNativeFont(this.fontPlain.deriveFont(AWTTypeface.translateStyle(style), szf), size);
    }

    private static int translateStyle(int style) {
        int out = 0;
        if ((style & 1) != 0) {
            out |= 1;
        }
        if ((style & 2) != 0) {
            out |= 2;
        }
        return out;
    }
}

