/*
 * Decompiled with CFR 0.152.
 */
package datum;

import datum.DatumCharClass;
import datum.DatumRuntimeIOException;
import datum.DatumSrcLoc;
import datum.DatumStreamingVisitor;
import java.io.IOException;
import java.io.StringWriter;

public final class DatumWriter
extends DatumStreamingVisitor {
    public final Appendable base;
    public State queued = State.None;
    public int indent = 0;

    public DatumWriter(Appendable base) {
        this.base = base;
    }

    public static String objectToString(Object obj) {
        StringWriter sw = new StringWriter();
        DatumWriter dw = new DatumWriter(sw);
        dw.visitTree(obj, DatumSrcLoc.NONE);
        return sw.toString();
    }

    protected void putChar(char c) {
        try {
            this.base.append(c);
        }
        catch (IOException e) {
            throw new DatumRuntimeIOException(e);
        }
    }

    protected void emitQueued(boolean listEnd) {
        if (this.queued == State.QueuedIndent) {
            for (int i = 0; i < this.indent; ++i) {
                this.putChar('\t');
            }
        } else if (this.queued == State.AfterToken && !listEnd) {
            this.putChar(' ');
        }
        this.queued = State.None;
    }

    private void putEscape(char c) {
        if (c == '\r') {
            this.putChar('\\');
            this.putChar('r');
        } else if (c == '\n') {
            this.putChar('\\');
            this.putChar('n');
        } else if (c == '\t') {
            this.putChar('\\');
            this.putChar('t');
        } else if (c < ' ' || c == '\u007f' || c == 'r' || c == 'n' || c == 't' || c == 'x') {
            this.putChar('\\');
            this.putChar('x');
            String hex = Integer.toHexString(c);
            if (hex.length() == 1) {
                this.putChar('0');
            }
            for (char c2 : hex.toCharArray()) {
                this.putChar(c2);
            }
            this.putChar(';');
        } else {
            this.putChar('\\');
            this.putChar(c);
        }
    }

    public void visitComment(String comment) {
        this.emitQueued(false);
        this.putChar(';');
        this.putChar(' ');
        for (char c : comment.toCharArray()) {
            if (c == '\n') {
                this.visitNewline();
                this.emitQueued(false);
                this.putChar(';');
                this.putChar(' ');
                continue;
            }
            this.putChar(c);
        }
        this.visitNewline();
    }

    public void visitNewline() {
        this.putChar('\n');
        this.queued = State.QueuedIndent;
    }

    @Override
    public void visitString(String s, DatumSrcLoc srcLoc) {
        this.emitQueued(false);
        this.putChar('\"');
        for (char c : s.toCharArray()) {
            if (c < ' ' || c == '\u007f' || c == '\"') {
                this.putEscape(c);
                continue;
            }
            this.putChar(c);
        }
        this.putChar('\"');
        this.queued = State.AfterToken;
    }

    private void putPIDChar(char c) {
        DatumCharClass cc = DatumCharClass.identify(c);
        if (!cc.isValidPID) {
            this.putEscape(c);
        } else {
            this.putChar(c);
        }
    }

    @Override
    public void visitId(String s, DatumSrcLoc srcLoc) {
        this.emitQueued(false);
        if (s.length() == 0) {
            this.putChar('#');
            this.putChar('{');
            this.putChar('}');
            this.putChar('#');
        } else if (s.length() == 1) {
            char chr = s.charAt(0);
            DatumCharClass cls = DatumCharClass.identify(chr);
            if (cls != DatumCharClass.Content && cls != DatumCharClass.Sign) {
                this.putEscape(chr);
            } else {
                this.putChar(chr);
            }
        } else {
            boolean isFirst = true;
            for (char c : s.toCharArray()) {
                if (isFirst) {
                    if (DatumCharClass.identify(c) != DatumCharClass.Content) {
                        this.putEscape(c);
                    } else {
                        this.putChar(c);
                    }
                    isFirst = false;
                    continue;
                }
                this.putPIDChar(c);
            }
        }
        this.queued = State.AfterToken;
    }

    @Override
    public void visitBoolean(boolean value, DatumSrcLoc srcLoc) {
        this.emitQueued(false);
        this.putChar('#');
        this.putChar(value ? (char)'t' : 'f');
        this.queued = State.AfterToken;
    }

    @Override
    public void visitNull(DatumSrcLoc srcLoc) {
        this.emitQueued(false);
        this.putChar('#');
        this.putChar('n');
        this.putChar('i');
        this.putChar('l');
        this.queued = State.AfterToken;
    }

    @Override
    public void visitInt(long value, DatumSrcLoc srcLoc) {
        this.emitQueued(false);
        for (char c : Long.toString(value).toCharArray()) {
            this.putChar(c);
        }
        this.queued = State.AfterToken;
    }

    @Override
    public void visitFloat(double value, DatumSrcLoc srcLoc) {
        this.emitQueued(false);
        if (!Double.isFinite(value)) {
            this.putChar('#');
            this.putChar('i');
            if (Double.isInfinite(value)) {
                this.putChar(value > 0.0 ? (char)'+' : '-');
                this.putChar('i');
                this.putChar('n');
                this.putChar('f');
                this.putChar('.');
                this.putChar('0');
            } else {
                this.putChar('+');
                this.putChar('n');
                this.putChar('a');
                this.putChar('n');
                this.putChar('.');
                this.putChar('0');
            }
        } else {
            for (char c : Double.toString(value).toCharArray()) {
                this.putChar(c);
            }
        }
        this.queued = State.AfterToken;
    }

    @Override
    public DatumWriter visitList(DatumSrcLoc srcLoc) {
        this.emitQueued(false);
        this.putChar('(');
        this.queued = State.None;
        return this;
    }

    @Override
    public void visitEnd(DatumSrcLoc srcLoc) {
        this.emitQueued(true);
        this.putChar(')');
        this.queued = State.AfterToken;
    }

    public static enum State {
        None,
        QueuedIndent,
        AfterToken;

    }
}

