/*
 * Decompiled with CFR 0.152.
 */
package datum;

import datum.DatumSrcLoc;
import datum.DatumSymbol;
import datum.DatumTreeVisitor;
import datum.DatumVisitor;
import java.util.List;

public final class DatumTreeUtils {
    private DatumTreeUtils() {
    }

    public static DatumVisitor decVisitor(VisitorLambda h) {
        return new LambdaVisitor(h);
    }

    public static DatumSymbol sym(String s) {
        return new DatumSymbol(s);
    }

    public static boolean isSym(Object o, String s) {
        if (o instanceof DatumSymbol) {
            return ((DatumSymbol)o).id.equals(s);
        }
        return false;
    }

    public static int cInt(Object o) {
        return ((Number)o).intValue();
    }

    public static long cLong(Object o) {
        return ((Number)o).longValue();
    }

    public static double cDouble(Object o) {
        return ((Number)o).doubleValue();
    }

    public static float cFloat(Object o) {
        return ((Number)o).floatValue();
    }

    public static List<Object> cList(Object o) {
        return (List)o;
    }

    public static interface VisitorLambda {
        public void handle(Object var1, DatumSrcLoc var2);
    }

    private static final class LambdaVisitor
    extends DatumTreeVisitor {
        public final VisitorLambda handler;

        public LambdaVisitor(VisitorLambda h) {
            this.handler = h;
        }

        @Override
        public void visitTree(Object obj, DatumSrcLoc srcLoc) {
            this.handler.handle(obj, srcLoc);
        }

        @Override
        public void visitEnd(DatumSrcLoc loc) {
        }
    }
}

