/*
 * Decompiled with CFR 0.152.
 */
package datum;

import datum.DatumPositionedException;
import datum.DatumSrcLoc;
import datum.DatumTokenType;
import datum.DatumVisitor;
import java.util.Stack;

public abstract class DatumTokenSource {
    public abstract boolean read();

    public abstract String contents();

    public abstract String position();

    public abstract DatumSrcLoc srcLoc();

    public abstract DatumTokenType type();

    public final boolean visitValue(DatumVisitor visitor) {
        Stack<DatumVisitor> storedListVisitors = new Stack<DatumVisitor>();
        Stack<String> storedListStarts = new Stack<String>();
        String listStart = null;
        do {
            if (!this.read()) {
                if (storedListVisitors.isEmpty()) {
                    return false;
                }
                throw new DatumPositionedException(this.srcLoc(), "EOF during list started here");
            }
            switch (this.type()) {
                case ID: {
                    visitor.visitId(this.contents(), this.srcLoc());
                    break;
                }
                case SpecialID: {
                    String c = this.contents();
                    if (c.equalsIgnoreCase("t")) {
                        visitor.visitBoolean(true, this.srcLoc());
                        break;
                    }
                    if (c.equalsIgnoreCase("f")) {
                        visitor.visitBoolean(false, this.srcLoc());
                        break;
                    }
                    if (c.equals("{}#")) {
                        visitor.visitId("", this.srcLoc());
                        break;
                    }
                    if (c.equalsIgnoreCase("nil")) {
                        visitor.visitNull(this.srcLoc());
                        break;
                    }
                    if (c.startsWith("x") || c.startsWith("X")) {
                        long l;
                        try {
                            l = Long.valueOf(c.substring(1), 16);
                        }
                        catch (NumberFormatException nfe2) {
                            throw new DatumPositionedException(this.srcLoc(), "Invalid hex constant: " + c, nfe2);
                        }
                        visitor.visitInt(l, this.srcLoc());
                        break;
                    }
                    if (c.equalsIgnoreCase("i+inf.0")) {
                        visitor.visitFloat(Double.POSITIVE_INFINITY, this.srcLoc());
                        break;
                    }
                    if (c.equalsIgnoreCase("i-inf.0")) {
                        visitor.visitFloat(Double.NEGATIVE_INFINITY, this.srcLoc());
                        break;
                    }
                    if (c.equalsIgnoreCase("i+nan.0")) {
                        visitor.visitFloat(Double.NaN, this.srcLoc());
                        break;
                    }
                    throw new DatumPositionedException(this.srcLoc(), "Unknown special ID sequence: " + c);
                }
                case String: {
                    visitor.visitString(this.contents(), this.srcLoc());
                    break;
                }
                case ListStart: {
                    storedListVisitors.push(visitor);
                    storedListStarts.push(listStart);
                    visitor = visitor.visitList(this.srcLoc());
                    listStart = this.position();
                    break;
                }
                case ListEnd: {
                    if (storedListVisitors.isEmpty()) {
                        throw new DatumPositionedException(this.srcLoc(), "List end with no list");
                    }
                    visitor.visitEnd(this.srcLoc());
                    visitor = (DatumVisitor)storedListVisitors.pop();
                    listStart = (String)storedListStarts.pop();
                    break;
                }
                case Numeric: {
                    this.visitNumeric(visitor, this.contents());
                }
            }
        } while (!storedListVisitors.isEmpty());
        return true;
    }

    private final void visitNumeric(DatumVisitor visitor, String c) {
        long l = 0L;
        try {
            l = Long.valueOf(c);
        }
        catch (NumberFormatException nfe1) {
            double d = 0.0;
            try {
                d = Double.valueOf(c);
            }
            catch (NumberFormatException nfe2) {
                throw new DatumPositionedException(this.srcLoc(), "Invalid number: " + c);
            }
            visitor.visitFloat(d, this.srcLoc());
            return;
        }
        visitor.visitInt(l, this.srcLoc());
    }

    public final void visit(DatumVisitor visitor) {
        while (this.visitValue(visitor)) {
        }
    }
}

