/*
 * Decompiled with CFR 0.152.
 */
package datum;

import datum.DatumPositionedException;
import datum.DatumSrcLoc;
import datum.DatumSymbol;
import datum.DatumVisitor;
import java.lang.reflect.Array;
import java.util.List;

public abstract class DatumStreamingVisitor
extends DatumVisitor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void visitTree(Object obj, DatumSrcLoc loc) {
        if (obj == null) {
            this.visitNull(loc);
            return;
        } else if (obj instanceof String) {
            this.visitString((String)obj, loc);
            return;
        } else if (obj instanceof DatumSymbol) {
            this.visitId(((DatumSymbol)obj).id, loc);
            return;
        } else if (obj instanceof Number) {
            if (obj instanceof Byte) {
                this.visitInt(((Byte)obj).byteValue(), loc);
                return;
            } else if (obj instanceof Short) {
                this.visitInt(((Short)obj).shortValue(), loc);
                return;
            } else if (obj instanceof Integer) {
                this.visitInt(((Integer)obj).intValue(), loc);
                return;
            } else if (obj instanceof Long) {
                this.visitInt((Long)obj, loc);
                return;
            } else if (obj instanceof Double) {
                this.visitFloat((Double)obj, loc);
                return;
            } else {
                if (!(obj instanceof Float)) throw new DatumPositionedException(loc, "Cannot handle visiting number " + obj);
                this.visitFloat(((Float)obj).floatValue(), loc);
            }
            return;
        } else if (obj instanceof Boolean) {
            this.visitBoolean((Boolean)obj, loc);
            return;
        } else if (obj instanceof List) {
            DatumVisitor sub = this.visitList(loc);
            for (Object elm : (List)obj) {
                sub.visitTree(elm, loc);
            }
            sub.visitEnd(loc);
            return;
        } else {
            if (!obj.getClass().isArray()) throw new DatumPositionedException(loc, "Cannot handle visiting datum " + obj);
            DatumVisitor sub = this.visitList(loc);
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                sub.visitTree(Array.get(obj, i), loc);
            }
            sub.visitEnd(loc);
        }
    }
}

