/*
 * Decompiled with CFR 0.152.
 */
package datum;

import datum.DatumCharClass;
import datum.DatumPositionedException;
import datum.DatumRuntimeIOException;
import datum.DatumSrcLoc;
import datum.DatumTokenSource;
import datum.DatumTokenType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class DatumReaderTokenSource
extends DatumTokenSource {
    private Reader reader;
    private String tokenContents;
    private DatumTokenType tokenType;
    private int holdingCell = -1;
    private DatumCharClass lastCharClass;
    private int lineNumber = 1;
    private int tokenLineNumber = 1;
    public final String fileName;
    private DatumSrcLoc lastSrcLoc = null;
    private int lastSrcLocLineNumber = -1;

    public DatumReaderTokenSource(String fn, Reader r) {
        this.fileName = fn;
        this.reader = r;
    }

    public DatumReaderTokenSource(String fn, String s) {
        this(fn, new StringReader(s));
    }

    private int readerRead() {
        int chr;
        try {
            chr = this.reader.read();
        }
        catch (IOException e) {
            throw new DatumPositionedException(this.srcLoc(), (Throwable)new DatumRuntimeIOException(e));
        }
        if (chr == 10) {
            ++this.lineNumber;
        }
        return chr;
    }

    private int decodeNextChar() {
        if (this.holdingCell != -1) {
            int tmp = this.holdingCell;
            this.holdingCell = -1;
            return tmp;
        }
        int val = this.readerRead();
        while (val == 13) {
            val = this.readerRead();
        }
        if (val == -1) {
            return -1;
        }
        this.lastCharClass = DatumCharClass.identify((char)val);
        if (this.lastCharClass == DatumCharClass.Meta) {
            if (val != 92) {
                throw new DatumPositionedException(this.srcLoc(), "Invalid character " + val);
            }
        } else {
            return val;
        }
        this.lastCharClass = DatumCharClass.Content;
        val = this.readerRead();
        if (val == -1) {
            throw new DatumPositionedException(this.srcLoc(), "\\ without escape");
        }
        if (val == 10) {
            throw new DatumPositionedException(this.srcLoc(), "\\ with newline");
        }
        if (val == 114) {
            return 13;
        }
        if (val == 110) {
            return 10;
        }
        if (val == 116) {
            return 9;
        }
        if (val == 120) {
            int res = 0;
            while (true) {
                int dig;
                if ((dig = this.readerRead()) == -1) {
                    throw new DatumPositionedException(this.srcLoc(), "Interrupted hex escape");
                }
                if (dig == 59) break;
                res <<= 4;
                try {
                    res |= Integer.parseInt(Character.toString((char)dig), 16);
                }
                catch (NumberFormatException nfe) {
                    throw new DatumPositionedException(this.srcLoc(), "Bad hex escape");
                }
            }
            char[] data = Character.toChars(res);
            if (data.length == 2) {
                this.holdingCell = data[1];
            }
            return data[0];
        }
        return val;
    }

    @Override
    public boolean read() {
        int dec;
        char decChar = '\u0000';
        while (true) {
            int dec2;
            if ((dec2 = this.decodeNextChar()) == -1) {
                return false;
            }
            decChar = (char)dec2;
            if (this.lastCharClass == DatumCharClass.Whitespace || this.lastCharClass == DatumCharClass.Newline) continue;
            if (this.lastCharClass != DatumCharClass.LineComment) break;
            do {
                if ((dec2 = this.decodeNextChar()) != -1) continue;
                return false;
            } while (this.lastCharClass != DatumCharClass.Newline);
        }
        this.tokenLineNumber = this.lineNumber;
        this.tokenContents = null;
        if (this.lastCharClass.aloneToken != null) {
            this.tokenType = this.lastCharClass.aloneToken;
            return true;
        }
        if (this.lastCharClass == DatumCharClass.String) {
            StringBuilder sb = new StringBuilder();
            while (true) {
                int dec3;
                if ((dec3 = this.decodeNextChar()) == -1) {
                    throw new DatumPositionedException(this.srcLoc(), "interrupted string");
                }
                if (this.lastCharClass == DatumCharClass.String) break;
                decChar = (char)dec3;
                sb.append(decChar);
            }
            this.tokenType = DatumTokenType.String;
            this.tokenContents = sb.toString();
            return true;
        }
        boolean digit = this.lastCharClass == DatumCharClass.Digit;
        boolean sign = this.lastCharClass == DatumCharClass.Sign;
        boolean specialID = this.lastCharClass == DatumCharClass.SpecialID;
        StringBuilder sb = new StringBuilder();
        if (!specialID) {
            sb.append(decChar);
        }
        while ((dec = this.decodeNextChar()) != -1) {
            if (!this.lastCharClass.isValidPID) {
                this.holdingCell = dec;
                break;
            }
            decChar = (char)dec;
            sb.append(decChar);
        }
        this.tokenContents = sb.toString();
        this.tokenType = digit ? DatumTokenType.Numeric : (sign && this.tokenContents.length() != 1 ? DatumTokenType.Numeric : (specialID ? DatumTokenType.SpecialID : DatumTokenType.ID));
        return true;
    }

    @Override
    public String position() {
        if (this.tokenType != null) {
            if (this.tokenContents != null) {
                return this.fileName + "L" + this.tokenLineNumber + ":" + (Object)((Object)this.tokenType) + "[" + this.tokenContents + "]";
            }
            return this.fileName + "L" + this.tokenLineNumber + ":" + (Object)((Object)this.tokenType);
        }
        return this.fileName + "L" + this.tokenLineNumber;
    }

    @Override
    public DatumSrcLoc srcLoc() {
        if (this.lastSrcLoc == null || this.lastSrcLocLineNumber != this.tokenLineNumber) {
            this.lastSrcLoc = new DatumSrcLoc(this.fileName, this.tokenLineNumber);
            this.lastSrcLocLineNumber = this.tokenLineNumber;
        }
        return this.lastSrcLoc;
    }

    @Override
    public String contents() {
        return this.tokenContents;
    }

    @Override
    public DatumTokenType type() {
        return this.tokenType;
    }
}

