/*
 * Decompiled with CFR 0.152.
 */
package datum;

import datum.DatumTokenType;

public enum DatumCharClass {
    Content(true, false, null),
    Whitespace(false, false, null),
    Newline(false, false, null),
    LineComment(false, false, null),
    String(false, false, null),
    ListStart(false, false, DatumTokenType.ListStart),
    ListEnd(false, false, DatumTokenType.ListEnd),
    SpecialID(true, false, null),
    Digit(true, true, null),
    Sign(true, true, null),
    Meta(false, false, null);

    public final boolean isValidPID;
    public final boolean isNumericStart;
    public final DatumTokenType aloneToken;

    private DatumCharClass(boolean pid, boolean ns, DatumTokenType alone) {
        this.isValidPID = pid;
        this.isNumericStart = ns;
        this.aloneToken = alone;
    }

    public static DatumCharClass identify(char c) {
        if (c == '\n') {
            return Newline;
        }
        if (c == '\t' || c == ' ') {
            return Whitespace;
        }
        if (c < ' ' || c == '\u007f' || c == '\\') {
            return Meta;
        }
        if (c == ';') {
            return LineComment;
        }
        if (c == '\"') {
            return String;
        }
        if (c == '(') {
            return ListStart;
        }
        if (c == ')') {
            return ListEnd;
        }
        if (c == '#') {
            return SpecialID;
        }
        if (c == '-') {
            return Sign;
        }
        if (c >= '0' && c <= '9') {
            return Digit;
        }
        return Content;
    }
}

