#ifdef PXTONEDLL_EXPORTS
#define DLLAPI __declspec(dllexport) // DLL 鑤 export Ƃ
#else
#define DLLAPI __declspec(dllimport) // DLL g import Ƃ
#endif

// C++ ł C łg悤ɂ
#ifdef __cplusplus
extern "C"{
#endif



typedef BOOL (* PXTONEPLAY_CALLBACK)( long clock, BOOL bEnd ); // -v.0.7.1.N
typedef bool (*   PXTNPLAY_CALLBACK)( int  clock            ); //  v.0.8.N.N-

// ȉ pxtone֐Q ==========================================

// @brief pxtone 𐶐܂B
// @param[in] hWnd:@@@@ EChEnhnĂ
// @param[in] channel_num:@̃`lw肵ĂB ( 1:m / 2:XeI )
// @param[in] sps:@@@@@ bԃTvO[głB@@@( 11025 / 22050 / 44100 )
// @param[in] bps:@@@@@PTv\rbgłB ( 8 / 16 )
// @param[in] buffer_sec:@@ ȂĐ̂Ɏgpobt@TCYbŎw肵܂B(  0.1 )
// @param[in] bDirectSound:@( true -> DirectSound / false -> WAVEMAPPER )
// @param[in] pProc:@@@@ TvOɌĂ΂֐łBNULL ł܂܂B
// @returns pxtone ̏ ( true / false )
bool DLLAPI pxtn_Ready( HWND hWnd, int channel_num, int sps, int bps, float buffer_sec, bool bDirectSound, PXTNPLAY_CALLBACK pProc );

// @brief pxtone Đݒ肵܂B
// @param[in] hWnd:@@@@ EChEnhnĂ
// @param[in] channel_num:@`l
// @param[in] sps:@@@@@ bԃTv
// @param[in] bps:@@@@@rbg
// @param[in] buffer_sec:@@ obt@TCYb
// @param[in] bDirectSound:@( true -> DirectSound / false -> WAVEMAPPER )
// @param[in] pProc:@@@@ R[obN֐
// @returns pxtone ̏ ( true / false )
bool DLLAPI pxtn_Reset( HWND hWnd, int channel_num, int sps, int bps, float buffer_sec, bool bDirectSound, PXTNPLAY_CALLBACK pProc );

// @brief pxtone ŐꂽDirectSound擾B
// @brief 擾DirectSound͎Ń[XȂ悤ɒӂĂB
// @returns DirectSound̃|C^(LPDIRECTSOUND)
void DLLAPI *pxtn_GetDirectSound( void );

// @brief XgG[擾
// @returns G[̃bZ[W
const char DLLAPI *pxtn_GetLastError( void );

// @brief pxtone ̉擾܂
// @param[out] p_channel_num:@@`lłB
// @param[out] p_sps: @@@@@@bԃTvO[głB
// @param[out] p_bps:@@@@@@PTv\rbgłB
// @param[out] p_sample_per_buf:@TvÕobt@ɎwꂽTCYB
void DLLAPI pxtn_GetQuality( int *p_channel_num, int *p_sps, int *p_bps, int *p_sample_per_buf );

// @brief \[Xo[W擾
// @param[out] p1: vX.0.0.0
// @param[out] p2: v0.X.0.0
// @param[out] p3: v0.0.X.0
// @param[out] p4: v0.0.0.X
// @returns ׂẴp[^x (vX.X.X.X)
int DLLAPI pxtn_GetVersion( int *p1, int *p2, int *p3, int *p4 );

// @brief pxtone J܂
// @returns pxtone ̊J ( true / false )
bool DLLAPI pxtn_Release( void );

// @brief Ȃǂݍ݂܂ (t@CE\[X)
// @param[in] hModule:@\[Xǂޏꍇ̓W[nhw肵܂BNULL łȂB
// @param[in] type_name: \[Xǂޏꍇ̓\[X̎ޖBOt@Cǂޏꍇ NULLB
// @param[in] file_name:@t@CpX̓\[XB
// @returns Ȃ̓ǂݍ ( true / false )
bool DLLAPI pxtn_Tune_Load( HMODULE hModule, const char *type_name, const char *file_name );

// @brief Ȃǂݍ ()
// @param[in] p:@ \[X̃f[^
// @param[in] size: \[X̃TCY
// @returns Ȃ̓ǂݍ ( true / false )
bool DLLAPI pxtn_Tune_Read( void *p, int size );

// @brief Ȃ܂
// @returns Ȃ̉ ( true / false )
bool DLLAPI pxtn_Tune_Release( void );

// @brief ȂĐ܂
// @param[in] start_sample: JnʒułB Stop  Fadeout Ŏ擾lݒ肵܂B0 ōŏB
// @param[in] fadein_msec: tF[hCꍇ͂Ɏԁi~bjw肵܂B
// @param[in] volume:@@ Ȃ̃{[B
// @returns Ȃ̍Đ ( true / false )
bool DLLAPI pxtn_Tune_Start( int start_sample, int fadein_msec, float volume );

// @brief tF[hAEgXCb`ČݍĐTv擾܂
// @param[in] msec: tF[hAEgԁi~bj
// @returns ~̋Ȃ̈ʒu擾܂B
int DLLAPI pxtn_Tune_Fadeout( int msec );

// @brief Ȃ̃{[ݒ肵܂B1.0 őŁA0.5 łB
// @param[in] v: {[ݒ肷B
void DLLAPI pxtn_Tune_SetVolume( float v );

// @brief Ȃ~ČݍĐTv擾
// @returns ~̋Ȃ̈ʒu擾܂B
int DLLAPI pxtn_Tune_Stop( void );

// @brief Đǂ𒲂ׂ܂
// @returns Đ̏ ( true / false )
bool DLLAPI pxtn_Tune_IsStreaming( void );

// @brief [vĐ ON/OFF ؂ւ܂
// @param[in] bLoop: Đ[v / Đ[vȂ
void DLLAPI pxtn_Tune_SetLoop( bool bLoop );

// @brief Ȃ̏擾܂
// @param[out] p_beat_num:@ q
// @param[out] p_beat_tempo: r[ge|
// @param[out] p_beat_clock:@NbN
// @param[out] p_meas_num:@ߐ
void DLLAPI pxtn_Tune_GetInformation( int *p_beat_num, float *p_beat_tempo, int *p_beat_clock, int *p_meas_num );

// @brief s[g߂擾܂
// @returns s[g
int DLLAPI pxtn_Tune_GetRepeatMeas( void );

// Lt߂擾܂ (LASTCxg߁B΍ŏI)
// @returns ߑ
int DLLAPI pxtn_Tune_GetPlayMeas( void );

// @brief Ȃ̖̂擾܂
// @returns ̕
const char DLLAPI *pxtn_Tune_GetName( void );

// @brief Ȃ̃Rg擾܂
// @returns Rg
const char DLLAPI *pxtn_Tune_GetComment( void );

// @brief w̃AhXɍĐobt@݂܂
// @brief .
// @brief P. ̊֐gpꍇ pxtone_Ready() ̈ buffer_sec ɂ 0 ݒ肵ĂB
//            pxtone ̃Xg[~O@\ɂȂ܂B
// @brief Q. Ȃ̃[h pxtone_Tune_Start() IĂ炱̊֐ĂяoĂB
// @brief R. sample_num ̓TCYł͂ȂăTvłB
// @brief : 11025hz 2ch 8bit PbfoꍇAsample_num  11025 w肷B
//            p ɂ 22050oCg̍Đobt@܂B
// @brief S. Xg[~O@\LȎƓl pxtone_Tune_Fadeout() ̊֐g܂B
// @param[out] p:@@@@@ Đobt@foAhXł
// @param[in] sample_num: ރTvł
// @returns ܂ꍇ true ȊO false
bool DLLAPI pxtn_Tune_Vomit( void *p, int sample_num );

// @brief jbg̏Kp
// @param[out] unit:@@ Ώۂ̃jbg
// @param[out] bMute:@ / Ȃ
// @returns ̓Kp ( true / false )
bool DLLAPI pxtn_Tune_MuteUnit( int unit, bool bMute );




// sXgmCY𐶐܂
typedef struct
{
    unsigned char *p_buf;
    int            size ;
}PXTONENOISEBUFFER;

// @brief ptnoise ̂߂ pxtnFrequency 
// @brief pxtone_Ready() ɌĂłꍇ͕Kv܂B
void DLLAPI pxtn_Noise_Initialize( void );

// @brief ptnoise ̃obt@J܂
// @param[in] p_noise: ꂽ ptnoise obt@
void DLLAPI pxtn_Noise_Release( PXTONENOISEBUFFER *p_noise );

// @brief ptnoise ŉf[^𐶐܂ (t@CE\[X)
// @param[in] name:@@@@ \[X@@ ݒBOt@C̏ꍇ̓t@CpXB
// @param[in] type:@@@@@\[X^CvݒBOt@C̏ꍇNULLB
// @param[in] channel_num:@ptnoise ̃`l
// @param[in] sps:@@@@@ bԃTv
// @param[in] bps:@@@@@rbg
// @returns ꂽ ptnoise obt@
PXTONENOISEBUFFER DLLAPI *pxtn_Noise_Create( const char *name, const char *type, int channel_num, int sps, int bps );

// @brief ptnoise ŉf[^𐶐܂ ()
// @param[in] p_designdata:@@mCYfUCobt@ւ̃|C^
// @param[in] designdata_size:@mCYfUCobt@̃TCY
// @param[in] channel_num:@@ptnoise ̃`l
// @param[in] sps:@@@@@@ bԃTv
// @param[in] bps:@@@@@@rbg
// @returns ꂽ ptnoise obt@
PXTONENOISEBUFFER DLLAPI *pxtn_Noise_Create_FromMemory( const char *p_designdata, int designdata_size, int channel_num, int sps, int bps );










// Overload calls ---------------------------------------------------------------------

// @brief Initializes pxtone.
// @param hWnd:@@@  Window Handle of the application
// @param channel_num: Specifies the number of channels. ( 1: Mono / 2: Stereo )
// @param sps:@@@@   Sample rate per seconds. ( 11025 / 22050 / 44100 )
// @param bps:@@@@  Number of bits representing one sample. ( 8 / 16 )
// @param buffer_sec:@   Specifies the buffer size in seconds to play the song. ( recommended: 0.1 )
// @param bDirectSound: ( true -> DirectSound / false -> WAVEMAPPER )
// @param pProc:@@@   A function called during playback. Can be set to NULL.
// @returns Pxtone preparation ( true / false )
BOOL DLLAPI pxtone_Ready( HWND hWnd, long channel_num, long sps, long bps, float buffer_sec, BOOL bDirectSound, PXTONEPLAY_CALLBACK pProc );
// bool DLLAPI pxtone_Ready( HWND hWnd, int  channel_num, int  sps, int  bps, float buffer_sec, bool bDirectSound, PXTONEPLAY_CALLBACK pProc );

// @brief Reconfigures pxtone.
// @param hWnd:@@@  Window Handle of the application
// @param channel_num: Specifies the number of channels. ( 1:Mono / 2:Stereo )
// @param sps:@@@@   Sample rate per seconds. ( 11025 / 22050 / 44100 )
// @param bps:@@@@  Number of bits representing one sample. ( 8 / 16 )
// @param buffer_sec:@   Specifies the buffer size in seconds to play the song. ( recommended: 0.1 )
// @param bDirectSound: ( true -> DirectSound / false -> WAVEMAPPER )
// @param pProc:@@@   A function called during playback. Can be set to NULL.
// @returns Pxtone preparation ( true / false )
BOOL DLLAPI pxtone_Reset( HWND hWnd, long channel_num, long sps, long bps, float buffer_sec, BOOL bDirectSound, PXTONEPLAY_CALLBACK pProc ); BOOL DLLAPI pxtone_ResetSampling( HWND hWnd, long channel_num, long sps, long bps, float buffer_sec, BOOL bDirectSound, PXTONEPLAY_CALLBACK pProc );
// bool DLLAPI pxtone_Reset( HWND hWnd, int  channel_num, int  sps, int  bps, float buffer_sec, bool bDirectSound, PXTONEPLAY_CALLBACK pProc );

// @brief Retrieves the DirectSound generated by pxtone.
// @brief Be careful not to release this DirectSound if you have acquired it!
// @returns Pointer of the DirectSound (LPDIRECTSOUND)
void DLLAPI *pxtone_GetDirectSound( void );

// @brief Retrieves the last occurred error.
// @returns Error message
const char DLLAPI *pxtone_GetLastError( void ); const char DLLAPI *pxtone_Tune_GetLastError( void );

// @brief Retrieves the sound quality from pxtone.
// @param p_channel_num:@ Channel number
// @param p_sps: @@@@@  Sample rate
// @param p_bps:@@@@@  Bits per sample
// @param p_sample_per_buf: Allocated size of the sampling buffer
void DLLAPI pxtone_GetQuality( long *p_channel_num, long *p_sps, long *p_bps, long *p_sample_per_buf );
// void DLLAPI pxtone_GetQuality( int *p_channel_num, int *p_sps, int *p_bps, int *p_sample_per_buf );

// @brief Gets the version number of the DLL.
// @returns Version number, or '-1' if something go wrong
long DLLAPI pxtone_GetVersion( void );

// @brief Releases pxtone.
// @returns Release proccess ( true / false )
BOOL DLLAPI pxtone_Release( void );

// @brief Loads the song. (from file / resource)
// @param hModule:@If you're gonna read from a resource, specify the module handle. Otherwise, NULL is fine.
// @param type_name: The resource type name if is a resource, or NULL if is an external file.
// @param file_name:@The file path or resource name.
// @returns Reading proccess ( true / false )
BOOL DLLAPI pxtone_Tune_Load( HMODULE hModule, const char *type_name, const char *file_name );

// @brief Loads the song. (from memory)
// @param p:@ Resource data
// @param size: Resource size
// @returns Reading proccess ( true / false )
BOOL DLLAPI pxtone_Tune_Read( void *p, long size );
// bool DLLAPI pxtone_Tune_Read( void *p, int size );

// @brief Releases song data from memory.
// @returns Release proccess ( true / false )
BOOL DLLAPI pxtone_Tune_Release( void );

// @brief Plays the loaded song.
// @param start_sample: The playback position. Can be set to a value got from Stop or Fadeout. 0 is the beginning.
// @param fadein_msec: If you want to fade in, specify the time here. (milliseconds)
// @param volume:@@  Song volume.
// @returns Starting proccess ( true / false )
BOOL DLLAPI pxtone_Tune_Start( long start_sample, long fadein_msec ); BOOL DLLAPI pxtone_Tune_Play( long start_sample, long fade_msec );
// BOOL DLLAPI pxtone_Tune_Start( long start_sample, long fadein_msec, float volume );

// @brief Fades the song out, and gets the current playback position.
// @param msec: Fadeout time (miliseconds)
// @returns Playback position when stopped
long DLLAPI pxtone_Tune_Fadeout( long msec );
// int DLLAPI pxtone_Tune_Fadeout( int msec );

// @brief Sets the song volume. 1.0 is max volume and 0.5 is half.
// @param v: Desired value
void DLLAPI pxtone_Tune_SetVolume( float v );
// void DLLAPI pxtone_Tune_SetVolume( double v );

// @brief Stops the song, and gets the current playback position.
// @returns Playback position when stopped
long DLLAPI pxtone_Tune_Stop( void );

// @brief Checks if it's currently playing.
// @returns Playback state ( true / false )
BOOL DLLAPI pxtone_Tune_IsStreaming( void ); BOOL DLLAPI pxtone_Tune_IsPlaying( void );

// @brief Toggles loop playback ON/OFF.
// @param bLoop: Loop / Play once ( true / false )
void DLLAPI pxtone_Tune_SetLoop( BOOL bLoop );
// void DLLAPI pxtone_Tune_SetLoop( bool bLoop );

// @brief Gets song information.
// @param p_beat_num:@ Number of beats
// @param p_beat_tempo: Song BPM
// @param p_beat_clock:@Beat clock
// @param p_meas_num:@Total measures of the song
void DLLAPI pxtone_Tune_GetInformation( long *p_beat_num, float *p_beat_tempo, long *p_beat_clock, long *p_meas_num );
// void DLLAPI pxtone_Tune_GetInformation( int *p_beat_num, float *p_beat_tempo, int *p_beat_clock, int *p_meas_num );

// @brief Gets the repeat measure.
// @returns Number of the repeat measure (REPEAT event)
long DLLAPI pxtone_Tune_GetRepeatMeas( void );

// Gets all valid measures from the song. (LAST event, or the last measure from the file)
// @returns Total number of measures
long DLLAPI pxtone_Tune_GetPlayMeas( void );

// @brief Gets the song name.
// @returns Name string
const char DLLAPI *pxtone_Tune_GetName( void );

// @brief Gets the song comment.
// @returns Comment string
const char DLLAPI *pxtone_Tune_GetComment( void );

// @brief Writes the playback buffer to the specified address.
// @brief .
// @brief 1. To use this function, set the 'buffer_sec' from pxtone_Ready() to 0.
//           The streaming procedure from pxtone will be disabled.
// @brief 2. Then, call this function after loading the song and calling pxtone_Tune_Start().
// @brief 3. The 'sample_num' here is the sample NUMBER, not the size.
// @brief Ex: To output 11025hz 2ch 8bit for 1 second, set 'sample_num' to '11025'.
//            '22050' bytes of the playback buffer will then be written to 'p'.
// @brief 4. Functions like pxtone_Tune_Fadeout() can be used the same way the streaming procedure does.
// @param p:@@@@@ Address to dump the playback buffer
// @param sample_num: The number of samples to write
// @returns If there is more to write, TRUE; otherwise, FALSE
BOOL DLLAPI pxtone_Tune_Vomit( void *p, long sample_num );
// bool DLLAPI pxtone_Tune_Vomit( void *p, int sample_num );

// @brief Applies mute to a unit.
// @param unit:@  Target unit
// @param bMute: Mute / Unmute
// @returns Mute operation ( true / false )
BOOL DLLAPI pxtone_Tune_MuteUnit( long unit, BOOL bMute );

// @brief Initializes 'ptnoise' generation.
// @brief Not necessary if you have already called pxtone_Ready().
void DLLAPI pxtone_Noise_Initialize( void );

// @brief Releases the generated 'ptnoise' buffer from memory.
// @param p_noise: 'ptnoise' struct
void DLLAPI pxtone_Noise_Release( PXTONENOISEBUFFER *p_noise );

// @brief Generates audio data with ptNoise. (from a file or resource)
// @param name:@@@   The resource         name. If it's a file, set the file path.
// @param type:@@@@ The resource type name. If it's a file, set it to NULL.
// @param channel_num: Channel number of the 'ptnoise'
// @param sps:@@@@   Sample rate
// @param bps:@@@@   Bits per sample
// @returns Generated 'ptnoise' buffer
PXTONENOISEBUFFER DLLAPI *pxtone_Noise_Create( const char *name, const char *type, long channel_num, long sps, long bps );
// PXTONENOISEBUFFER DLLAPI *pxtone_Noise_Create( const char *name, const char *type, int channel_num, int sps, int bps );

// @brief ptnoise Generates audio data with ptNoise. (from memory)
// @param p_designdata:@ Pointer of the buffer containing the noise design
// @param designdata_size: Size of the buffer containing the noise design
// @param channel_num:@  Channel number of the 'ptnoise'
// @param sps:@@@@@   Sample rate
// @param bps:@@@@@   Bits per sample
// @returns Generated 'ptnoise' buffer
PXTONENOISEBUFFER DLLAPI *pxtone_Noise_Create_FromMemory( const char *p_designdata, int designdata_size, long channel_num, long sps, long bps );
// PXTONENOISEBUFFER DLLAPI *pxtone_Noise_Create_FromMemory( const char *p_designdata, int designdata_size, int channel_num, int sps, int bps );
// ------------------------------------------------------------------------------------

#ifdef __cplusplus
}
#endif
